/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.client.utils.FXHelper;
import growthcraft.core.shared.io.nbt.INBTItemSerializable;
import growthcraft.core.shared.tileentity.GrowthcraftTileBase;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IFluidTankOperable;
import growthcraft.core.shared.utils.Pair;
import growthcraft.core.shared.utils.PulseStepper;
import growthcraft.core.shared.utils.SpatialRandom;
import growthcraft.core.shared.utils.TickUtils;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import growthcraft.milk.common.tileentity.IPancheonTile;
import growthcraft.milk.common.tileentity.struct.CheeseCurd;
import growthcraft.milk.shared.definition.ICheeseType;
import growthcraft.milk.shared.init.GrowthcraftMilkFluids;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHangingCurds
extends GrowthcraftTileBase
implements ITickable,
INBTItemSerializable {
    private SpatialRandom sprand = new SpatialRandom();
    private PulseStepper wheyPulsar = new PulseStepper(TickUtils.seconds(15), 10);
    private PulseStepper animPulsar = new PulseStepper(10, 4);
    private int serverStep;
    @SideOnly(value=Side.CLIENT)
    private int clientStep;
    private CheeseCurd cheeseCurd = new CheeseCurd();

    private IPancheonTile getPancheonTile() {
        for (int i = 1; i < 3; ++i) {
            BlockPos ofsPos = this.func_174877_v().func_177979_c(i);
            TileEntity te = this.field_145850_b.func_175625_s(ofsPos);
            if (te instanceof IPancheonTile) {
                return (IPancheonTile)te;
            }
            if (!this.field_145850_b.func_175623_d(ofsPos)) break;
        }
        return null;
    }

    public ICheeseType getCheeseType() {
        return this.cheeseCurd.getType();
    }

    public int getRenderColor() {
        return this.cheeseCurd.getRenderColor();
    }

    public float getProgress() {
        return this.cheeseCurd.getAgeProgress();
    }

    public boolean isDried() {
        return this.cheeseCurd.isDried();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cheeseCurd.needClientUpdate) {
                this.cheeseCurd.needClientUpdate = false;
                this.markForUpdate();
            }
            this.cheeseCurd.update();
            if (this.wheyPulsar.update() == PulseStepper.State.PULSE && !this.isDried()) {
                FluidStack stack;
                IFluidTankOperable fh;
                IPancheonTile pancheonTile = this.getPancheonTile();
                if (pancheonTile != null && (fh = pancheonTile.getPancheonFluidHandler()).canFill(EnumFacing.UP, (stack = GrowthcraftMilkFluids.whey.asFluidStack(100)).getFluid())) {
                    fh.fill(EnumFacing.UP, stack, true);
                }
                ++this.serverStep;
                this.markDirtyAndUpdate();
            }
        } else {
            if (this.clientStep != this.serverStep) {
                this.clientStep = this.serverStep;
                this.animPulsar.reset();
            }
            if (this.animPulsar.update() == PulseStepper.State.PULSE && !this.isDried()) {
                Pair<Double, Double> p = this.sprand.nextCenteredD2();
                double px = (double)this.field_174879_c.func_177958_n() + 0.5 + (Double)p.left * 0.5;
                double py = (double)this.field_174879_c.func_177956_o() + 0.125;
                double pz = (double)this.field_174879_c.func_177952_p() + 0.5 + (Double)p.right * 0.5;
                FXHelper.dropParticle(this.field_145850_b, px, py, pz, GrowthcraftMilkFluids.whey.getItemColor());
            }
        }
    }

    protected void readCheeseCurdFromNBT(NBTTagCompound nbt) {
        this.cheeseCurd.readFromNBT(nbt);
    }

    protected void readWheyPulsarFromNBT(NBTTagCompound nbt) {
        this.wheyPulsar.readFromNBT(nbt, "whey_pulsar");
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readCheeseCurdFromNBT(nbt);
        this.readWheyPulsarFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_HangingCurds(NBTTagCompound nbt) {
        this.readCheeseCurdFromNBT(nbt);
        this.readWheyPulsarFromNBT(nbt);
    }

    protected void writeCheeseCurdToNBT(NBTTagCompound nbt) {
        this.cheeseCurd.writeToNBT(nbt);
    }

    protected void writeWheyPulsarToNBT(NBTTagCompound nbt) {
        this.wheyPulsar.writeToNBT(nbt, "whey_pulsar");
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeCheeseCurdToNBT(nbt);
        this.writeWheyPulsarToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_HangingCurds(NBTTagCompound nbt) {
        this.writeCheeseCurdToNBT(nbt);
        this.writeWheyPulsarToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_HangingCurds(ByteBuf stream) throws IOException {
        this.cheeseCurd.readFromStream(stream);
        this.wheyPulsar.readFromStream(stream);
        this.serverStep = stream.readInt();
        return true;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_HangingCurds(ByteBuf stream) throws IOException {
        this.cheeseCurd.writeToStream(stream);
        this.wheyPulsar.writeToStream(stream);
        stream.writeInt(this.serverStep);
        return true;
    }

    public ItemStack asItemStack() {
        ICheeseType type = this.cheeseCurd.getType();
        ItemStack stack = type.getCurdBlocks().asStack();
        NBTTagCompound tag = ItemBlockHangingCurds.openNBT(stack);
        this.writeToNBTForItem(tag);
        return stack;
    }
}

