/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.inventory.AccesibleSlots;
import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.inventory.InventoryProcessor;
import growthcraft.core.shared.io.nbt.NBTTagStringList;
import growthcraft.core.shared.io.stream.StreamUtils;
import growthcraft.core.shared.item.ItemTest;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.component.TileHeatingComponent;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IItemOperable;
import growthcraft.core.shared.tileentity.feature.ITileHeatedDevice;
import growthcraft.core.shared.tileentity.feature.ITileNamedFluidTanks;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.tileentity.cheesevat.CheeseVatState;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.config.GrowthcraftMilkConfig;
import growthcraft.milk.shared.definition.ICheeseType;
import growthcraft.milk.shared.events.EventCheeseVat;
import growthcraft.milk.shared.fluids.MilkFluidTags;
import growthcraft.milk.shared.init.GrowthcraftMilkFluids;
import growthcraft.milk.shared.init.GrowthcraftMilkItems;
import growthcraft.milk.shared.processing.cheesevat.ICheeseVatRecipe;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityCheeseVat
extends GrowthcraftTileDeviceBase
implements ITickable,
IItemOperable,
ITileHeatedDevice,
ITileNamedFluidTanks,
ITileProgressiveDevice {
    private static FluidTankType[] recipeTanks = new FluidTankType[]{FluidTankType.PRIMARY, FluidTankType.RECIPE};
    private static AccesibleSlots accessibleSlots = new AccesibleSlots(new int[][]{{0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}});
    private DeviceFluidSlot primaryFluidSlot;
    private DeviceFluidSlot rennetFluidSlot;
    private DeviceFluidSlot wasteFluidSlot;
    private boolean recheckRecipe;
    private TileHeatingComponent heatComponent;
    private CheeseVatState vatState;
    private float progress;
    private int progressMax;

    public TileEntityCheeseVat() {
        this.primaryFluidSlot = new DeviceFluidSlot(this, FluidTankType.PRIMARY.id);
        this.rennetFluidSlot = new DeviceFluidSlot(this, FluidTankType.RENNET.id);
        this.wasteFluidSlot = new DeviceFluidSlot(this, FluidTankType.WASTE.id);
        this.heatComponent = new TileHeatingComponent(this, 0.5f);
        this.vatState = CheeseVatState.IDLE;
    }

    public boolean isIdle() {
        return this.vatState == CheeseVatState.IDLE;
    }

    public boolean isWorking() {
        return !this.isIdle();
    }

    private void setVatState(CheeseVatState state) {
        this.vatState = state;
        this.func_70296_d();
    }

    public String getVatState() {
        return this.vatState.name();
    }

    private void goIdle() {
        this.setVatState(CheeseVatState.IDLE);
    }

    private void setupProgress(int value) {
        this.progress = 0.0f;
        this.progressMax = value;
    }

    private void resetProgress() {
        this.setupProgress(0);
    }

    @Override
    public float getDeviceProgress() {
        if (this.progressMax > 0) {
            return this.progress / (float)this.progressMax;
        }
        return 0.0f;
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        if (this.progressMax > 0) {
            return (int)(this.progress * (float)scale / (float)this.progressMax);
        }
        return 0;
    }

    @Override
    public boolean isHeated() {
        return this.heatComponent.getHeatMultiplier() > 0.0f;
    }

    @Override
    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    @Override
    public int getHeatScaled(int scale) {
        return (int)((float)scale * MathHelper.func_76131_a((float)this.getHeatMultiplier(), (float)0.0f, (float)1.0f));
    }

    public void markForRecipeCheck() {
        this.recheckRecipe = true;
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        this.markForRecipeCheck();
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(GrowthcraftMilkConfig.cheeseVatPrimaryTankCapacity), new FluidTank(GrowthcraftMilkConfig.cheeseVatRennetTankCapacity), new FluidTank(GrowthcraftMilkConfig.cheeseVatWasteTankCapacity), new FluidTank(GrowthcraftMilkConfig.cheeseVatRecipeTankCapacity)};
    }

    public int getVatFluidCapacity() {
        return this.getFluidTank(FluidTankType.PRIMARY.id).getCapacity() + this.getFluidTank(FluidTankType.WASTE.id).getCapacity() + this.getFluidTank(FluidTankType.RECIPE.id).getCapacity();
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 3, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grcmilk.CheeseVat";
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return accessibleSlots.slotsAt(side);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return accessibleSlots.sideContains(side, index);
    }

    private boolean activateCurdTransition(boolean checkOnly) {
        ItemStack starterCultureStack = GrowthcraftMilkItems.starterCulture.asStack();
        int slot = InventoryProcessor.instance().findItemSlot((IInventory)this, starterCultureStack);
        if (slot < 0) {
            GrowthcraftMilk.logger.debug("No Starter Culture found!");
            return false;
        }
        FluidStack milkStack = this.primaryFluidSlot.get();
        if (!FluidTest.hasTags(milkStack, MilkFluidTags.MILK)) {
            GrowthcraftMilk.logger.debug("Primary Fluid is NOT milk.");
            return false;
        }
        if (!this.primaryFluidSlot.isFull()) {
            GrowthcraftMilk.logger.debug("Primary Fluid Tank is NOT full.");
            return false;
        }
        FluidStack rennetStack = this.rennetFluidSlot.get();
        if (!FluidTest.hasTags(rennetStack, MilkFluidTags.RENNET)) {
            GrowthcraftMilk.logger.debug("Rennet contains NON rennet fluid.");
            return false;
        }
        if (!this.rennetFluidSlot.isFull()) {
            GrowthcraftMilk.logger.debug("Rennet Fluid Tank is NOT full.");
            return false;
        }
        if (!checkOnly) {
            this.func_70298_a(slot, 1);
            this.primaryFluidSlot.set(GrowthcraftFluidUtils.exchangeFluid(milkStack, GrowthcraftMilkFluids.curds.getFluid()));
            this.rennetFluidSlot.clear();
            this.wasteFluidSlot.fill(GrowthcraftMilkFluids.whey.asFluidStack(GrowthcraftMilkConfig.cheeseVatMilkToCurdsWheyAmount), true);
            GrowthcraftMilk.MILK_BUS.post((Event)new EventCheeseVat.EventCheeseVatMadeCurds(this));
        }
        return true;
    }

    private boolean activateWheyTransition(boolean checkOnly) {
        FluidStack milkStack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(milkStack, MilkFluidTags.WHEY) && this.primaryFluidSlot.isFull()) {
            if (!checkOnly) {
                Fluid fluid = GrowthcraftMilkItems.SimpleCheeseTypes.RICOTTA.getFluids().getFluid();
                this.primaryFluidSlot.set(GrowthcraftFluidUtils.exchangeFluid(this.primaryFluidSlot.get(), fluid));
                this.wasteFluidSlot.fill(GrowthcraftMilkFluids.whey.asFluidStack(GrowthcraftMilkConfig.cheeseVatWheyToRicottaWheyAmount), true);
                GrowthcraftMilk.MILK_BUS.post((Event)new EventCheeseVat.EventCheeseVatMadeCheeseFluid(this));
            }
            return true;
        }
        return false;
    }

    private boolean commitMilkCurdRecipe(boolean checkOnly) {
        ItemStack stack;
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (FluidTankType t : recipeTanks) {
            FluidStack stack2 = this.getFluidStack(t.id);
            if (!FluidTest.isValid(stack2)) continue;
            fluids.add(stack2);
        }
        for (int i = 0; i < this.func_70302_i_() && !ItemUtils.isEmpty(stack = this.func_70301_a(i)); ++i) {
            items.add(stack);
        }
        ICheeseVatRecipe recipe = MilkRegistry.instance().cheeseVat().findRecipe(fluids, items);
        if (recipe != null) {
            List<IMultiItemStacks> inputItems = recipe.getInputItemStacks();
            List<IMultiFluidStacks> inputFluids = recipe.getInputFluidStacks();
            int[] invSlots = InventoryProcessor.instance().findItemSlots((IInventory)this, inputItems);
            if (InventoryProcessor.instance().slotsAreValid((IInventory)this, invSlots) && InventoryProcessor.instance().checkSlotsAndSizes((IInventory)this, inputItems, invSlots) && FluidTest.hasEnoughAndExpected(inputFluids, fluids)) {
                if (!checkOnly) {
                    InventoryProcessor.instance().consumeItemsInSlots((IInventory)this, inputItems, invSlots);
                    for (int fluidIndex = 0; fluidIndex < fluids.size(); ++fluidIndex) {
                        FluidStack fluidStack = (FluidStack)fluids.get(fluidIndex);
                        FluidTankType t = recipeTanks[fluidIndex];
                        if (fluidStack == null) continue;
                        this.drainFluidTank(t.id, fluidStack.amount, true);
                    }
                    for (ItemStack stack3 : recipe.getOutputItemStacks()) {
                        if (ItemUtils.isEmpty(stack3)) continue;
                        ItemUtils.spawnItemStackAtTile(stack3.func_77946_l(), this, this.field_145850_b.field_73012_v);
                    }
                    int tankIndex = 0;
                    Iterator<FluidStack> iterator = recipe.getOutputFluidStacks().iterator();
                    if (iterator.hasNext()) {
                        FluidStack stack4 = iterator.next();
                        if (stack4 != null) {
                            this.fillFluidTank(tankIndex, stack4.copy(), true);
                        }
                        ++tankIndex;
                    }
                    this.func_70296_d();
                    GrowthcraftMilk.MILK_BUS.post((Event)new EventCheeseVat.EventCheeseVatMadeCheeseFluid(this));
                }
                return true;
            }
        }
        return false;
    }

    private void commitRecipe() {
        FluidStack stack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(stack, MilkFluidTags.MILK_CURDS) && this.commitMilkCurdRecipe(true)) {
            this.setupProgress(GrowthcraftMilkConfig.cheeseVatCheeseTime);
            this.setVatState(CheeseVatState.PREPARING_CHEESE);
        }
    }

    private void onFinishedProgress() {
        switch (this.vatState) {
            case PREPARING_RICOTTA: {
                this.activateWheyTransition(false);
                break;
            }
            case PREPARING_CURDS: {
                this.activateCurdTransition(false);
                break;
            }
            case PREPARING_CHEESE: {
                this.commitMilkCurdRecipe(false);
                break;
            }
        }
        this.resetProgress();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.heatComponent.update();
            if (!this.isIdle()) {
                if (this.isHeated()) {
                    if (this.progress < (float)this.progressMax) {
                        this.progress += 1.0f * this.getHeatMultiplier();
                    } else {
                        this.onFinishedProgress();
                        this.goIdle();
                    }
                } else if (this.progress > 0.0f) {
                    this.progress -= 1.0f;
                } else {
                    this.goIdle();
                }
            } else if (this.recheckRecipe) {
                this.recheckRecipe = false;
                if (this.isHeated()) {
                    this.commitRecipe();
                }
            }
        }
    }

    private boolean primaryTankHasMilk() {
        return FluidTest.hasTags(this.primaryFluidSlot.get(), MilkFluidTags.MILK);
    }

    private boolean primaryTankHasCurds() {
        return FluidTest.hasTags(this.primaryFluidSlot.get(), MilkFluidTags.MILK_CURDS);
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return FluidTest.hasTags(fluid, MilkFluidTags.MILK) || FluidTest.hasTags(fluid, MilkFluidTags.WHEY) || FluidTest.hasTags(fluid, MilkFluidTags.RENNET) || MilkRegistry.instance().cheeseVat().isFluidIngredient(fluid);
    }

    @Override
    protected FluidStack doDrain(EnumFacing dir, int amount, boolean doDrain) {
        if (!this.isIdle()) {
            return null;
        }
        return this.wasteFluidSlot.consume(amount, doDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing dir, FluidStack stack, boolean doDrain) {
        if (!FluidTest.areStacksEqual(this.wasteFluidSlot.get(), stack)) {
            return null;
        }
        return this.doDrain(dir, stack.amount, doDrain);
    }

    @Override
    protected int doFill(EnumFacing dir, FluidStack stack, boolean doFill) {
        if (!this.isIdle()) {
            return 0;
        }
        int result = 0;
        if (FluidTest.hasTags(stack, MilkFluidTags.MILK) || FluidTest.hasTags(stack, MilkFluidTags.WHEY)) {
            result = this.primaryFluidSlot.fill(stack, doFill);
        } else if (FluidTest.isValidAndExpected(GrowthcraftMilkFluids.rennet.getFluid(), stack)) {
            if (this.primaryTankHasMilk()) {
                result = this.rennetFluidSlot.fill(stack, doFill);
            }
        } else if (MilkRegistry.instance().cheeseVat().isFluidIngredient(stack) && this.primaryTankHasCurds()) {
            result = this.fillFluidTank(FluidTankType.RECIPE.id, stack, doFill);
        }
        return result;
    }

    private void playSuccessfulSwordActivationFX() {
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
    }

    private boolean doSwordActivation(EntityPlayer _player, ItemStack _stack) {
        if (!this.isHeated()) {
            GrowthcraftMilk.logger.debug("Vat is NOT heated.");
            return false;
        }
        GrowthcraftMilk.logger.debug("Activating Using Sword.");
        FluidStack milkStack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(milkStack, MilkFluidTags.MILK)) {
            GrowthcraftMilk.logger.debug("Activating Curd Transition.");
            if (this.activateCurdTransition(true)) {
                this.setupProgress(GrowthcraftMilkConfig.cheeseVatCurdTime);
                this.setVatState(CheeseVatState.PREPARING_CURDS);
                this.playSuccessfulSwordActivationFX();
                return true;
            }
        } else if (FluidTest.hasTags(milkStack, MilkFluidTags.WHEY)) {
            GrowthcraftMilk.logger.debug("Activating Whey Transition.");
            if (this.activateWheyTransition(true)) {
                this.setupProgress(GrowthcraftMilkConfig.cheeseVatWheyTime);
                this.setVatState(CheeseVatState.PREPARING_RICOTTA);
                this.playSuccessfulSwordActivationFX();
                return true;
            }
        }
        return false;
    }

    private boolean collectCurdInCheeseCloth(EntityPlayer player, ItemStack stack) {
        FluidStack fluidStack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(fluidStack, MilkFluidTags.CHEESE)) {
            Fluid fluid = fluidStack.getFluid();
            ICheeseType type = MilkRegistry.instance().cheese().getCheeseByFluid(fluid);
            if (type != null) {
                this.primaryFluidSlot.clear();
                ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
                ItemStack curdItemStack = type.getCurdBlocks().asStack();
                ItemUtils.addStackToPlayer(curdItemStack, player, false);
                return true;
            }
        }
        return false;
    }

    private boolean addItemIngredient(EntityPlayer player, ItemStack stack) {
        int slot = InventoryProcessor.instance().findNextEmpty((IInventory)this);
        if (slot == -1) {
            return false;
        }
        ItemStack result = ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
        this.func_70299_a(slot, result);
        return true;
    }

    @Override
    public boolean tryPlaceItem(IItemOperable.Action action, EntityPlayer player, ItemStack stack) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (!this.isIdle()) {
            return false;
        }
        if (!ItemTest.isValid(stack)) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemSword) {
            return this.doSwordActivation(player, stack);
        }
        if (GrowthcraftMilkItems.starterCulture.equals(item)) {
            return this.addItemIngredient(player, stack);
        }
        if (GrowthcraftMilkItems.cheeseCloth.equals(item)) {
            return this.collectCurdInCheeseCloth(player, stack);
        }
        if (MilkRegistry.instance().cheeseVat().isItemIngredient(stack)) {
            return this.addItemIngredient(player, stack);
        }
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (!this.isIdle()) {
            return false;
        }
        if (ItemUtils.isEmpty(onHand)) {
            int slot = InventoryProcessor.instance().findNextPresentFromEnd((IInventory)this);
            if (slot == -1) {
                return false;
            }
            ItemStack stack = InventoryProcessor.instance().yankSlot((IInventory)this, slot);
            ItemUtils.spawnItemStackAtEntity(stack, (Entity)player, this.field_145850_b.field_73012_v);
            return true;
        }
        return false;
    }

    @Override
    protected void markFluidDirty() {
        this.markForRecipeCheck();
        this.markDirtyAndUpdate();
    }

    @Override
    public void writeFluidTankNamesToTag(NBTTagCompound tag) {
        NBTTagStringList tagList = new NBTTagStringList();
        for (FluidTankType type : FluidTankType.VALUES) {
            tagList.add(type.getUnlocalizedName());
        }
        tag.func_74782_a("tank_names", (NBTBase)tagList.getTag());
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheeseVat(NBTTagCompound nbt) {
        if (nbt.func_74764_b("progress_max")) {
            this.progressMax = nbt.func_74762_e("progress_max");
        }
        if (nbt.func_74764_b("progress")) {
            this.progress = nbt.func_74760_g("progress");
        }
        this.heatComponent.readFromNBT(nbt, "heat_component");
        this.vatState = CheeseVatState.getStateSafe(nbt.func_74779_i("vat_state"));
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheeseVat(NBTTagCompound nbt) {
        nbt.func_74768_a("progress_max", this.progressMax);
        nbt.func_74776_a("progress", this.progress);
        this.heatComponent.writeToNBT(nbt, "heat_component");
        nbt.func_74778_a("vat_state", this.vatState.name);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheeseVat(ByteBuf stream) throws IOException {
        this.progressMax = stream.readInt();
        this.progress = stream.readFloat();
        this.heatComponent.readFromStream(stream);
        String name = "idle";
        name = StreamUtils.readStringASCII(stream);
        this.vatState = CheeseVatState.getStateSafe(name);
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheeseVat(ByteBuf stream) throws IOException {
        stream.writeInt(this.progressMax);
        stream.writeFloat(this.progress);
        this.heatComponent.writeToStream(stream);
        StreamUtils.writeStringASCII(stream, this.vatState.name);
        return false;
    }

    public int calcRedstone() {
        return this.getFluidAmountScaled(15, FluidTankType.PRIMARY.id);
    }

    public static enum FluidTankType {
        PRIMARY,
        RENNET,
        WASTE,
        RECIPE;

        public static final FluidTankType[] VALUES;
        public final int id = this.ordinal();
        public final String name = this.name().toLowerCase(Locale.ENGLISH);

        public String getUnlocalizedName() {
            return "grcmilk.cheese_vat.fluid_tank." + this.name;
        }

        static {
            VALUES = new FluidTankType[]{PRIMARY, RENNET, WASTE, RECIPE};
        }
    }
}

