/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.common.blocks;

import growthcraft.core.shared.block.BlockCheck;
import growthcraft.core.shared.block.ICropDataProvider;
import growthcraft.grapes.common.utils.GrapeBlockCheck;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public abstract class BlockGrapeVineBase
extends BlockBush
implements IPlantable,
ICropDataProvider,
IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)1);
    public static final PropertyInteger SUBTYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)7);
    private float growthRateMultiplier = 1.0f;

    public BlockGrapeVineBase() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(0)));
    }

    public void setGrowthRateMultiplier(float rate) {
        this.growthRateMultiplier = rate;
    }

    public float getGrowthRateMultiplier() {
        return this.growthRateMultiplier;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, BlockPos pos, IBlockState state) {
        int age = this.getAge(state);
        return (float)age / (float)this.getMaxAge();
    }

    protected boolean isGrapeVine(IBlockState state) {
        return GrapeBlockCheck.isGrapeVine(state.func_177230_c());
    }

    public int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState incrementGrowth(World world, BlockPos pos, IBlockState state) {
        int nextStage = this.getAge(state) + 1;
        if (nextStage > this.getMaxAge()) {
            return state;
        }
        IBlockState newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(nextStage));
        world.func_180501_a(pos, newState, 2);
        return newState;
    }

    public int getMaxAge() {
        return 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return super.getDrops(world, pos, state, fortune);
    }

    protected float getGrowthRate(World world, BlockPos pos) {
        return BlockCrops.func_180672_a((Block)this, (World)world, (BlockPos)pos);
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == Blocks.field_150346_d;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return BlockCheck.canSustainPlant((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, this);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    protected abstract IBlockState doGrowth(World var1, BlockPos var2, IBlockState var3);

    protected abstract boolean canUpdateGrowth(World var1, BlockPos var2);

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.canUpdateGrowth(worldIn, pos)) {
            float f = this.getGrowthRate(worldIn, pos);
            boolean continueGrowth = rand.nextInt((int)(this.getGrowthRateMultiplier() / f) + 1) == 0;
            boolean allowGrowthResult = ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)continueGrowth);
            if (!allowGrowthResult) {
                return;
            }
            IBlockState newState = this.doGrowth(worldIn, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)newState);
            return;
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.canUpdateGrowth(worldIn, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((double)rand.nextFloat() < 0.5) {
            this.doGrowth(worldIn, pos, state);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, SUBTYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 1)).func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf((meta & 0xE) >> 1));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= (Integer)state.func_177229_b((IProperty)AGE) & 1;
        return meta |= ((Integer)state.func_177229_b((IProperty)SUBTYPE) & 0xE) >> 1;
    }
}

