/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.fishtrap.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftFishtrapConfig {
    private static Configuration configuration;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_FISHTRAP = "fishtrap";
    public static boolean isDebug;
    public static String logLevel;
    public static boolean baitRequired;
    public static boolean strictBait;
    public static List<String> FISHTRAP_BAIT_TABLE;

    private GrowthcraftFishtrapConfig() {
    }

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-fistrap.cfg"));
        GrowthcraftFishtrapConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftFishtrapConfig.initGeneralConfig();
            GrowthcraftFishtrapConfig.initFishtrapConfig();
            GrowthcraftFishtrapConfig.initDebugConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft_fishtrap").log(Level.ERROR, "Unable to load configuration files for Growthcraft Fishtrap!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        logLevel = configuration.getString("log_level", CATEGORY_GENERAL, logLevel, "Log level specific to GrowthcraftFishtrap.");
    }

    private static void initFishtrapConfig() {
        baitRequired = configuration.getBoolean("baitRequired", CATEGORY_FISHTRAP, baitRequired, "Is bait required in order to catch any fish?");
        strictBait = configuration.getBoolean("enforceBaitTable", CATEGORY_FISHTRAP, strictBait, "Only bait in the authorizedFishBait list will be allowed.");
        FISHTRAP_BAIT_TABLE = Arrays.asList(configuration.getStringList("fishtrap_bait_list", CATEGORY_FISHTRAP, FISHTRAP_BAIT_TABLE.toArray(new String[0]), "Add the item's registry name on a new line for each item you want the fishtrap to use it as bait."));
    }

    private static void initDebugConfig() {
        if ((logLevel = configuration.getString("logLevel", CATEGORY_GENERAL, logLevel, "Set standard logging levels. (INFO, ERROR, DEBUG)")).equalsIgnoreCase("debug")) {
            isDebug = true;
        }
    }

    static {
        isDebug = false;
        logLevel = "info";
        baitRequired = false;
        strictBait = false;
        FISHTRAP_BAIT_TABLE = new ArrayList<String>(){
            {
                this.add("minecraft:rotten_flesh");
                this.add("minecraft:fish");
            }
        };
    }
}

