/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.device;

import growthcraft.core.shared.tileentity.device.DeviceBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class DeviceProgressive
extends DeviceBase {
    protected int time;
    protected int timeMax;

    public DeviceProgressive(TileEntity te) {
        super(te);
    }

    public float getProgress() {
        if (this.timeMax <= 0) {
            return 0.0f;
        }
        return (float)this.time / (float)this.timeMax;
    }

    public int getProgressScaled(int scale) {
        if (this.timeMax <= 0) {
            return 0;
        }
        return this.time * scale / this.timeMax;
    }

    public int getTime() {
        return this.time;
    }

    public int getTimeMax() {
        return this.timeMax;
    }

    public void setTime(int t) {
        this.time = t;
    }

    public void setTimeMax(int t) {
        this.timeMax = t;
    }

    public boolean resetTime() {
        if (this.time != 0) {
            this.setTime(0);
            return true;
        }
        return false;
    }

    public void increaseTime() {
        ++this.time;
    }

    public void update() {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.time = data.func_74762_e("time");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("time", this.time);
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.time = buf.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeInt(this.time);
        return false;
    }
}

