/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import com.google.common.base.Joiner;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.config.GrowthcraftConfiguration;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class UnitFormatter {
    public static final String fractionSeparator = TextFormatting.GRAY + " / ";

    private UnitFormatter() {
    }

    public static String fraction(String ... args) {
        return Joiner.on((String)fractionSeparator).join((Object[])args);
    }

    public static String fractionNum(int a, int b) {
        return UnitFormatter.fraction("" + TextFormatting.WHITE + a, "" + TextFormatting.WHITE + b);
    }

    public static String fluidBucketName(Fluid fluid) {
        return I18n.func_74838_a((String)("item.bucket." + fluid.getUnlocalizedName() + ".name"));
    }

    @Nullable
    public static String fluidModifier(Fluid fluid) {
        String modifierString;
        String modifierSrc = fluid.getUnlocalizedName() + ".modifier";
        if (modifierSrc.equals(modifierString = I18n.func_74838_a((String)modifierSrc))) {
            Collection<FluidTag> tags = CoreRegistry.instance().fluidDictionary().getFluidTags(fluid);
            if (tags == null || tags.size() == 0) {
                return null;
            }
            String str = "";
            for (FluidTag tag : tags) {
                if (GrowthcraftConfiguration.hidePoisonedBooze && tag.getName().equals("poisoned")) continue;
                str = str + (str.length() == 0 ? "" : ", ") + tag.getLocalizedName();
            }
            modifierString = str;
        }
        return TextFormatting.GREEN + modifierString;
    }

    @Nullable
    public static String fluidModifier(FluidStack fluid) {
        return UnitFormatter.fluidModifier(fluid.getFluid());
    }

    @Nullable
    public static String fluidName(FluidStack fluidStack) {
        if (fluidStack != null) {
            Fluid fluid = fluidStack.getFluid();
            String modifier = UnitFormatter.fluidModifier(fluid);
            if (modifier != null) {
                return I18n.func_74837_a((String)"grc.format.booze.name", (Object[])new Object[]{TextFormatting.WHITE + fluidStack.getLocalizedName(), modifier});
            }
            return I18n.func_74837_a((String)"grc.format.fluid.name", (Object[])new Object[]{TextFormatting.WHITE + fluidStack.getLocalizedName()});
        }
        return null;
    }

    @Nullable
    public static String fluidNameForContainer(FluidStack fluidStack) {
        String name = UnitFormatter.fluidName(fluidStack);
        if (name != null) {
            return name;
        }
        return UnitFormatter.invalidFluid();
    }

    public static String noItem() {
        return TextFormatting.GRAY + I18n.func_74838_a((String)"format.itemslot.empty");
    }

    public static String invalidItem() {
        return TextFormatting.RED + I18n.func_74838_a((String)"format.itemslot.invalid");
    }

    public static String noFluid() {
        return TextFormatting.GRAY + I18n.func_74838_a((String)"grc.format.tank.empty");
    }

    public static String invalidFluid() {
        return TextFormatting.RED + I18n.func_74838_a((String)"format.invalid_fluid");
    }

    public static String booleanAsState(boolean b) {
        return I18n.func_74838_a((String)("format.state." + b));
    }

    public static String booleanAsValue(boolean b) {
        return I18n.func_74838_a((String)("format.value." + b));
    }
}

