/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.effect;

import growthcraft.core.shared.effect.AbstractEffect;
import growthcraft.core.shared.effect.IEffect;
import growthcraft.core.shared.io.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractEffectList
extends AbstractEffect {
    protected List<IEffect> effects = new ArrayList<IEffect>();

    public <T extends AbstractEffectList> T clear() {
        this.effects.clear();
        return (T)this;
    }

    public <T extends AbstractEffectList> T concat(@Nonnull List<IEffect> otherEffects) {
        this.effects.addAll(otherEffects);
        return (T)this;
    }

    public <T extends AbstractEffectList> T concat(@Nonnull AbstractEffectList list) {
        this.effects.addAll(list.effects);
        return (T)this;
    }

    public <T extends AbstractEffectList> T add(@Nonnull IEffect effect) {
        this.effects.add(effect);
        return (T)this;
    }

    public IEffect get(int index) {
        return this.effects.get(index);
    }

    public <T extends AbstractEffectList> T set(int index, @Nonnull IEffect effect) {
        this.effects.set(index, effect);
        return (T)this;
    }

    public int size() {
        return this.effects.size();
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.effects.clear();
        NBTHelper.loadEffectsList(this.effects, data);
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        NBTHelper.writeEffectsList(data, this.effects);
    }
}

