/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.client.render;

import growthcraft.cellar.client.utils.FluidRenderUtils;
import growthcraft.core.shared.client.render.utils.RenderUtil;
import growthcraft.core.shared.fluids.IFluidTanks;
import growthcraft.core.shared.utils.BBox;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class TileFluidTanksSpecialRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer<T> {
    private final BBox fluidBBox;

    public TileFluidTanksSpecialRenderer(BBox fluidBBox) {
        this.fluidBBox = fluidBBox;
    }

    private double roundToPixel(double fluidHeight) {
        return (double)MathHelper.func_76128_c((double)(fluidHeight * 16.0 + 0.5)) / 16.0;
    }

    public void renderMaxFluid(@Nonnull T te, double x, double y, double z) {
        FluidRenderUtils.RenderedFluid rf = FluidRenderUtils.getActualFluidBBoxForMax(this.fluidBBox, (IFluidTanks)te);
        if (!rf.isNone()) {
            BBox renderedBBox = rf.getFluidBBox();
            RenderUtil.renderFluidCuboid(rf.getFluidStack(), te.func_174877_v(), x, y, z, renderedBBox.x0(), renderedBBox.y0(), renderedBBox.z0(), renderedBBox.x1(), renderedBBox.y1(), renderedBBox.z1());
        }
    }

    public int getDefaultTotalCapacity(@Nonnull T te) {
        int totalCap = 0;
        for (int i = 0; i < ((IFluidTanks)te).getTankCount(); ++i) {
            totalCap += ((IFluidTanks)te).getFluidTank(i).getCapacity();
        }
        return totalCap;
    }

    public void renderStackedFluid(@Nonnull T te, double x, double y, double z, int totalCap) {
        int numTanks = ((IFluidTanks)te).getTankCount();
        double y0 = this.fluidBBox.y0();
        double s = 1.0 / (double)totalCap;
        for (int i = 0; i < numTanks; ++i) {
            if (!((IFluidTanks)te).isFluidTankFilled(i)) continue;
            FluidStack fluidStack = ((IFluidTanks)te).getFluidStack(i);
            double h = this.roundToPixel(this.fluidBBox.h() * s * (double)fluidStack.amount);
            if (h <= 0.0) continue;
            RenderUtil.renderFluidCuboid(fluidStack, te.func_174877_v(), x, y, z, this.fluidBBox.x0(), y0, this.fluidBBox.z0(), this.fluidBBox.x1(), y0 + h, this.fluidBBox.z1());
            y0 += h;
        }
    }
}

