/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.block;

import growthcraft.core.shared.block.BlockPaddyBase;
import growthcraft.core.shared.block.IBlockRope;
import growthcraft.core.shared.init.GrowthcraftCoreBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockCheck {
    public static final EnumFacing[] DIR4 = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    public static final BlockDirection[] DIR8 = new BlockDirection[]{BlockDirection.NORTH, BlockDirection.SOUTH, BlockDirection.WEST, BlockDirection.EAST, BlockDirection.NORTH_WEST, BlockDirection.NORTH_EAST, BlockDirection.SOUTH_WEST, BlockDirection.SOUTH_EAST};

    private BlockCheck() {
    }

    public static EnumFacing randomDirection4(Random random) {
        return DIR4[random.nextInt(DIR4.length)];
    }

    public static BlockDirection randomDirection8(Random random) {
        return DIR8[random.nextInt(DIR8.length)];
    }

    public static boolean isWater(IBlockState blockState) {
        if (blockState == null) {
            return false;
        }
        return blockState.func_185904_a() == Material.field_151586_h;
    }

    public static boolean isBlockPaddy(Block block) {
        return block instanceof BlockPaddyBase;
    }

    public static boolean isRopeBlock(Block block) {
        return block instanceof IBlockRope;
    }

    public static boolean isRope(Block block) {
        return GrowthcraftCoreBlocks.rope_fence.equals(block);
    }

    public static boolean isRope(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return BlockCheck.isRope(block);
    }

    public static boolean canSustainPlantOn(IBlockState soilState, IBlockAccess world, BlockPos pos, EnumFacing dir, IPlantable plant) {
        return soilState != null && soilState.func_177230_c().canSustainPlant(soilState, world, pos, dir, plant);
    }

    public static boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing dir, IPlantable plant) {
        IBlockState soilState = world.func_180495_p(pos);
        return BlockCheck.canSustainPlantOn(soilState, world, pos, dir, plant);
    }

    public static Block getFarmableBlock(IBlockAccess world, BlockPos pos, EnumFacing dir, IPlantable plant) {
        IBlockState soilState = world.func_180495_p(pos);
        if (BlockCheck.canSustainPlantOn(soilState, world, pos, dir, plant)) {
            return soilState.func_177230_c();
        }
        return null;
    }

    public static boolean isBlockPlacableOnSide(World world, BlockPos pos, EnumFacing dir) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state != null) {
            return state.func_177230_c().isSideSolid(state, (IBlockAccess)world, pos, dir);
        }
        return false;
    }

    public static enum BlockDirection {
        DOWN(0, -1, 0),
        UP(0, 1, 0),
        NORTH(0, 0, -1),
        SOUTH(0, 0, 1),
        WEST(-1, 0, 0),
        EAST(1, 0, 0),
        UNKNOWN(0, 0, 0),
        NORTH_WEST(-1, 0, -1),
        NORTH_EAST(1, 0, -1),
        SOUTH_WEST(-1, 0, 1),
        SOUTH_EAST(1, 0, 1),
        DOWN_NORTH(0, -1, -1),
        DOWN_SOUTH(0, -1, 1),
        DOWN_WEST(-1, -1, 0),
        DOWN_EAST(1, -1, 0),
        DOWN_NORTH_WEST(-1, -1, -1),
        DOWN_NORTH_EAST(1, -1, -1),
        DOWN_SOUTH_WEST(-1, -1, 1),
        DOWN_SOUTH_EAST(1, -1, 1),
        UP_NORTH(0, 1, -1),
        UP_SOUTH(0, 1, 1),
        UP_WEST(-1, 1, 0),
        UP_EAST(1, 1, 0),
        UP_NORTH_WEST(-1, 1, -1),
        UP_NORTH_EAST(1, 1, -1),
        UP_SOUTH_WEST(-1, 1, 1),
        UP_SOUTH_EAST(1, 1, 1);

        public final int offsetX;
        public final int offsetY;
        public final int offsetZ;
        public final int flag;

        private BlockDirection(int x, int y, int z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
            this.flag = 1 << this.ordinal();
        }
    }
}

