/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftCellarConfig {
    public static Configuration configuration;
    public static final boolean enableDiscardButton = true;
    public static boolean boozeEffectsEnabled;
    public static boolean boozeIsWater;
    public static int fermentTime;
    public static int brewKettleMaxCap;
    public static boolean brewKettleFillsWithRain;
    public static int brewKettleRainFillPerUnit;
    public static boolean dropItemsInBrewKettle;
    public static boolean setFireToFallenLivingEntities;
    public static boolean fermentBarrelUseCachedRecipe;
    public static int fermentBarrelMaxCap;
    public static int cultureJarTimeMax;
    public static int cultureJarConsumption;
    public static int cultureJarMaxCap;
    public static int fruitPressMaxCap;
    public static boolean allowFallbackRecipes;
    private static final String CATEGORY_PRODUCTION = "production";

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-cellar.cfg"));
        GrowthcraftCellarConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftCellarConfig.initGeneralConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").log(Level.ERROR, "Unable to load configuration files for Growthcraft Cellar!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        allowFallbackRecipes = configuration.getBoolean("allowFallbackRecipes", CATEGORY_PRODUCTION, true, "If true then fallback recipes are activated. E.g. booze spoiling when using invalid ingredient.");
    }

    static {
        boozeEffectsEnabled = true;
        boozeIsWater = false;
        fermentTime = 24000;
        brewKettleMaxCap = 1000;
        brewKettleFillsWithRain = true;
        brewKettleRainFillPerUnit = 10;
        dropItemsInBrewKettle = true;
        setFireToFallenLivingEntities = true;
        fermentBarrelUseCachedRecipe = true;
        fermentBarrelMaxCap = 3000;
        cultureJarTimeMax = 1200;
        cultureJarConsumption = 250;
        cultureJarMaxCap = 1000;
        fruitPressMaxCap = 1000;
        allowFallbackRecipes = true;
    }
}

