/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.common.inventory.ContainerFruitPress;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.device.FruitPress;
import growthcraft.cellar.common.tileentity.fluids.CellarTank;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityFruitPress
extends TileEntityCellarDevice
implements ITickable,
ITileProgressiveDevice {
    private static final int[] allSlotIds = new int[]{0, 1};
    private static final int[] residueSlotIds = new int[]{0};
    private FruitPress fruitPress = new FruitPress(this, 0, 0, 1);

    @Override
    protected FluidTank[] createTanks() {
        int maxCap = GrowthcraftCellarConfig.fruitPressMaxCap;
        return new FluidTank[]{new CellarTank(maxCap, this)};
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 2);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.fruitPress";
    }

    @Override
    public String getGuiID() {
        return "growthcraft_cellar:fruit_press";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFruitPress(playerInventory, this);
    }

    @Override
    public float getDeviceProgress() {
        return this.fruitPress.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.fruitPress.getProgressScaled(scale);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.fruitPress.update();
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return allSlotIds;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        return index == 0;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return index == 0 ? side == EnumFacing.UP : side != EnumFacing.UP;
    }

    @Override
    protected void markFluidDirty() {
        super.markFluidDirty();
        this.markDirtyAndUpdate();
    }

    @Override
    protected void readTanksFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tank")) {
            this.getFluidTank(0).readFromNBT(nbt.func_74775_l("Tank"));
        } else {
            super.readTanksFromNBT(nbt);
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_FruitPress(NBTTagCompound nbt) {
        if (nbt.func_74762_e("FruitPress_version") > 0) {
            this.fruitPress.readFromNBT(nbt, "fruit_press");
        } else {
            this.fruitPress.readFromNBT(nbt);
        }
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_FruitPress(NBTTagCompound nbt) {
        this.fruitPress.writeToNBT(nbt, "fruit_press");
        nbt.func_74768_a("FruitPress_version", 2);
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        switch (id) {
            case 0: {
                this.fruitPress.setTime(v);
                break;
            }
            case 1: {
                this.fruitPress.setTimeMax(v);
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, this.fruitPress.getTime());
        iCrafting.func_71112_a(container, 1, this.fruitPress.getTimeMax());
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    protected int doFill(EnumFacing from, FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.drainFluidTank(0, maxDrain, doDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, FluidStack stack, boolean doDrain) {
        if (stack == null || !stack.isFluidEqual(this.getFluidStack(0))) {
            return null;
        }
        return this.doDrain(from, stack.amount, doDrain);
    }

    public static class FruitPressDataID {
        public static final int TIME = 0;
        public static final int TIME_MAX = 1;

        private FruitPressDataID() {
        }
    }
}

