/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.common.inventory.ContainerCultureJar;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.device.CultureGenerator;
import growthcraft.cellar.common.tileentity.device.YeastGenerator;
import growthcraft.cellar.common.tileentity.fluids.CellarTank;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.tileentity.component.TileHeatingComponent;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.ITileHeatedDevice;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityCultureJar
extends TileEntityCellarDevice
implements ITickable,
ITileHeatedDevice,
ITileProgressiveDevice {
    private static final int[] accessibleSlots = new int[]{0};
    private TileHeatingComponent heatComponent = new TileHeatingComponent(this, 1.0f);
    private CultureGenerator cultureGen = new CultureGenerator(this, this.heatComponent, 0, 0);
    private YeastGenerator yeastGen = new YeastGenerator(this, 0, 0);
    private int jarDeviceState;

    public TileEntityCultureJar() {
        this.yeastGen.setTimeMax(GrowthcraftCellarConfig.cultureJarTimeMax);
        this.yeastGen.setConsumption(GrowthcraftCellarConfig.cultureJarConsumption);
    }

    @Override
    public boolean isHeated() {
        return this.cultureGen.isHeated();
    }

    @Override
    public float getHeatMultiplier() {
        return this.cultureGen.getHeatMultiplier();
    }

    public boolean isCulturing() {
        return this.jarDeviceState == 1;
    }

    private DeviceProgressive getActiveDevice() {
        if (this.cultureGen.isHeated()) {
            return this.cultureGen;
        }
        return this.yeastGen;
    }

    private DeviceProgressive getActiveClientDevice() {
        if (this.jarDeviceState == 1) {
            return this.cultureGen;
        }
        return this.yeastGen;
    }

    @Override
    protected FluidTank[] createTanks() {
        int maxTankCap = GrowthcraftCellarConfig.cultureJarMaxCap;
        return new FluidTank[]{new CellarTank(maxTankCap, this)};
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.CultureJar";
    }

    @Override
    public String getGuiID() {
        return "growthcraft_cellar:culture_jar";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCultureJar(playerInventory, this);
    }

    @Override
    protected void markFluidDirty() {
        this.markForUpdate();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return accessibleSlots;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return index == 0;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        return false;
    }

    @Override
    protected int doFill(EnumFacing from, FluidStack resource, boolean shouldFill) {
        return this.fillFluidTank(0, resource, shouldFill);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, int maxDrain, boolean shouldDrain) {
        return this.drainFluidTank(0, maxDrain, shouldDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, FluidStack resource, boolean shouldDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluidTank(0).getFluid())) {
            return null;
        }
        return this.doDrain(from, resource.amount, shouldDrain);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.heatComponent.update();
            int lastState = this.jarDeviceState;
            DeviceProgressive prog = this.getActiveDevice();
            if (prog == this.cultureGen) {
                this.jarDeviceState = 1;
                this.yeastGen.resetTime();
            } else {
                this.jarDeviceState = 0;
                this.cultureGen.resetTime();
            }
            this.getActiveDevice().update();
            if (this.jarDeviceState != lastState) {
                this.markDirtyAndUpdate();
            }
        }
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        switch (CultureJarDataId.getByOrdinal(id)) {
            case YEAST_GEN_TIME: {
                this.yeastGen.setTime(v);
                break;
            }
            case YEAST_GEN_TIME_MAX: {
                this.yeastGen.setTimeMax(v);
                break;
            }
            case CULTURE_GEN_TIME: {
                this.cultureGen.setTime(v);
                break;
            }
            case CULTURE_GEN_TIME_MAX: {
                this.cultureGen.setTimeMax(v);
                break;
            }
            case HEAT_AMOUNT: {
                this.heatComponent.setHeatMultiplier((float)v / 32767.0f);
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, CultureJarDataId.YEAST_GEN_TIME.ordinal(), this.yeastGen.getTime());
        iCrafting.func_71112_a(container, CultureJarDataId.YEAST_GEN_TIME_MAX.ordinal(), this.yeastGen.getTimeMax());
        iCrafting.func_71112_a(container, CultureJarDataId.CULTURE_GEN_TIME.ordinal(), this.cultureGen.getTime());
        iCrafting.func_71112_a(container, CultureJarDataId.CULTURE_GEN_TIME_MAX.ordinal(), this.cultureGen.getTimeMax());
        iCrafting.func_71112_a(container, CultureJarDataId.HEAT_AMOUNT.ordinal(), (int)(this.heatComponent.getHeatMultiplier() * 32767.0f));
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CultureJar(NBTTagCompound nbt) {
        this.yeastGen.readFromNBT(nbt, "yeastgen");
        this.cultureGen.readFromNBT(nbt, "culture_gen");
        this.heatComponent.readFromNBT(nbt, "heat_component");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CultureJar(NBTTagCompound nbt) {
        this.yeastGen.writeToNBT(nbt, "yeastgen");
        this.cultureGen.writeToNBT(nbt, "culture_gen");
        this.heatComponent.writeToNBT(nbt, "heat_component");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_YeastGen(ByteBuf stream) throws IOException {
        this.jarDeviceState = stream.readInt();
        this.yeastGen.readFromStream(stream);
        this.cultureGen.readFromStream(stream);
        this.heatComponent.readFromStream(stream);
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_YeastGen(ByteBuf stream) throws IOException {
        stream.writeInt(this.jarDeviceState);
        this.yeastGen.writeToStream(stream);
        this.cultureGen.writeToStream(stream);
        this.heatComponent.writeToStream(stream);
        return false;
    }

    @Override
    public int getHeatScaled(int scale) {
        return (int)((float)scale * MathHelper.func_76131_a((float)this.getHeatMultiplier(), (float)0.0f, (float)1.0f));
    }

    @Override
    public float getDeviceProgress() {
        return this.getActiveClientDevice().getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.getActiveClientDevice().getProgressScaled(scale);
    }

    public static enum CultureJarDataId {
        YEAST_GEN_TIME,
        YEAST_GEN_TIME_MAX,
        CULTURE_GEN_TIME,
        CULTURE_GEN_TIME_MAX,
        HEAT_AMOUNT,
        UNKNOWN;

        public static final CultureJarDataId[] VALID;

        public static CultureJarDataId getByOrdinal(int ord) {
            if (ord >= 0 && ord < VALID.length) {
                return VALID[ord];
            }
            return UNKNOWN;
        }

        static {
            VALID = new CultureJarDataId[]{YEAST_GEN_TIME, YEAST_GEN_TIME_MAX, CULTURE_GEN_TIME, CULTURE_GEN_TIME_MAX, HEAT_AMOUNT};
        }
    }
}

