/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common;

import growthcraft.cellar.client.render.RenderBrewKettle;
import growthcraft.cellar.client.render.RenderCultureJar;
import growthcraft.cellar.client.render.RenderFruitPress;
import growthcraft.cellar.common.block.BlockBrewKettle;
import growthcraft.cellar.common.block.BlockCultureJar;
import growthcraft.cellar.common.block.BlockFermentBarrel;
import growthcraft.cellar.common.block.BlockFruitPress;
import growthcraft.cellar.common.block.BlockFruitPresser;
import growthcraft.cellar.common.item.ItemBarrelTap;
import growthcraft.cellar.common.item.ItemBrewKettleLid;
import growthcraft.cellar.common.item.ItemChievDummy;
import growthcraft.cellar.common.item.ItemYeast;
import growthcraft.cellar.common.potion.PotionCellar;
import growthcraft.cellar.common.stats.CellarAchievement;
import growthcraft.cellar.common.tileentity.TileEntityBrewKettle;
import growthcraft.cellar.common.tileentity.TileEntityCultureJar;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.common.tileentity.TileEntityFruitPress;
import growthcraft.cellar.common.tileentity.TileEntityFruitPresser;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.BoozeEffect;
import growthcraft.cellar.shared.booze.effect.EffectTipsy;
import growthcraft.cellar.shared.init.GrowthcraftCellarBlocks;
import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.cellar.shared.init.GrowthcraftCellarPotions;
import growthcraft.cellar.shared.processing.heatsource.user.UserHeatSourceEntry;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.definition.BlockDefinition;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.effect.EffectRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Init {
    private Init() {
    }

    public static void preInitBlocks() {
        GrowthcraftCellarBlocks.brewKettle = new BlockDefinition(new BlockBrewKettle("brew_kettle"));
        GrowthcraftCellarBlocks.fermentBarrel = new BlockDefinition(new BlockFermentBarrel("ferment_barrel"));
        GrowthcraftCellarBlocks.cultureJar = new BlockDefinition(new BlockCultureJar("culture_jar"));
        GrowthcraftCellarBlocks.fruitPress = new BlockDefinition(new BlockFruitPress("fruit_press"));
        GrowthcraftCellarBlocks.fruitPresser = new BlockDefinition(new BlockFruitPresser("fruit_presser"));
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftCellarBlocks.brewKettle.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarBlocks.brewKettle.registerBlock(registry);
        GrowthcraftCellarBlocks.fermentBarrel.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarBlocks.fermentBarrel.registerBlock(registry);
        GrowthcraftCellarBlocks.cultureJar.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarBlocks.cultureJar.registerBlock(registry);
        GrowthcraftCellarBlocks.fruitPress.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarBlocks.fruitPress.registerBlock(registry);
        GrowthcraftCellarBlocks.fruitPresser.registerBlock(registry);
    }

    public static void registerBlockItems(IForgeRegistry<Item> registry) {
        GrowthcraftCellarBlocks.brewKettle.registerBlockItem(registry);
        GrowthcraftCellarBlocks.fermentBarrel.registerBlockItem(registry);
        GrowthcraftCellarBlocks.cultureJar.registerBlockItem(registry);
        GrowthcraftCellarBlocks.fruitPress.registerBlockItem(registry);
    }

    public static void registerBlockRenders() {
        GrowthcraftCellarBlocks.brewKettle.registerItemRender();
        GrowthcraftCellarBlocks.fermentBarrel.registerItemRender();
        GrowthcraftCellarBlocks.cultureJar.registerItemRender();
        GrowthcraftCellarBlocks.fruitPress.registerItemRender();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockSpecialRenders() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBrewKettle.class, (TileEntitySpecialRenderer)new RenderBrewKettle());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCultureJar.class, (TileEntitySpecialRenderer)new RenderCultureJar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFruitPress.class, (TileEntitySpecialRenderer)new RenderFruitPress());
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBrewKettle.class, (String)"growthcraft_cellar:brew_kettle");
        GameRegistry.registerTileEntity(TileEntityFermentBarrel.class, (String)"growthcraft_cellar:ferment_barrel");
        GameRegistry.registerTileEntity(TileEntityCultureJar.class, (String)"growthcraft_cellar:culture_jar");
        GameRegistry.registerTileEntity(TileEntityFruitPress.class, (String)"growthcraft_cellar:fruit_press");
        GameRegistry.registerTileEntity(TileEntityFruitPresser.class, (String)"growthcraft_cellar:fruit_presser");
    }

    public static void preInitItems() {
        GrowthcraftCellarItems.chievItemDummy = new ItemDefinition(new ItemChievDummy("achievement_dummy"));
        GrowthcraftCellarItems.yeast = new ItemDefinition(new ItemYeast("yeast"));
        GrowthcraftCellarItems.brewKettleLid = new ItemDefinition(new ItemBrewKettleLid("brew_kettle_lid"));
        GrowthcraftCellarItems.barrelTap = new ItemDefinition(new ItemBarrelTap("barrel_tap"));
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        GrowthcraftCellarItems.chievItemDummy.registerItem(registry);
        GrowthcraftCellarItems.yeast.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarItems.yeast.registerItem(registry);
        GrowthcraftCellarItems.brewKettleLid.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarItems.brewKettleLid.registerItem(registry);
        GrowthcraftCellarItems.barrelTap.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftCellarItems.barrelTap.registerItem(registry);
    }

    public static void registerItemRenders() {
        GrowthcraftCellarItems.chievItemDummy.registerRender();
        GrowthcraftCellarItems.yeast.registerRenders(GrowthcraftCellarItems.EnumYeast.class);
        GrowthcraftCellarItems.brewKettleLid.registerRender();
        GrowthcraftCellarItems.barrelTap.registerRender();
    }

    public static void preInitEffects() {
        EffectRegistry reg = CoreRegistry.instance().getEffectsRegistry();
        reg.register("booze_effect", BoozeEffect.class);
        reg.register("booze_effect_list", BoozeEffect.BoozeEffectList.class);
        reg.register("tipsy", EffectTipsy.class);
    }

    public static void preInitHeatSources() {
    }

    public static void registerHeatSources() {
        GrowthcraftCellarApis.userApis.getUserHeatSources().addDefault("minecraft", "fire", UserHeatSourceEntry.newWildcardHeat(1.0f)).setComment("Fire!");
        GrowthcraftCellarApis.userApis.getUserHeatSources().addDefault("minecraft", "flowing_lava", UserHeatSourceEntry.newWildcardHeat(0.7f)).setComment("We need to register both states of lava, this when its flowing");
        GrowthcraftCellarApis.userApis.getUserHeatSources().addDefault("minecraft", "lava", UserHeatSourceEntry.newWildcardHeat(0.7f)).setComment("And when its a still pool.");
        GrowthcraftCellarApis.userApis.getUserHeatSources().addDefault(Blocks.field_189877_df.getRegistryName(), UserHeatSourceEntry.newWildcardHeat(0.7f)).setComment("Magma Block. Something like lava.");
    }

    public static void initYeasts() {
    }

    public static void registerYeasts() {
        OreDictionary.registerOre((String)"materialYeast", GrowthcraftCellarItems.yeast.getItem());
        for (GrowthcraftCellarItems.EnumYeast type : GrowthcraftCellarItems.EnumYeast.values()) {
            ItemStack yeastItemStack = type.asStack();
            OreDictionary.registerOre((String)type.toOreName(), (ItemStack)yeastItemStack);
            CellarRegistry.instance().yeast().addYeast(yeastItemStack);
        }
    }

    public static void registerPotions(IForgeRegistry<Potion> registry) {
        GrowthcraftCellarPotions.potionTipsy = new PotionCellar(false, 0, 1, 0).func_76390_b("potion.tipsy");
        Init.registerPotion(registry, GrowthcraftCellarPotions.potionTipsy);
        EffectTipsy.achievement = CellarAchievement.GET_DRUNK;
    }

    private static void registerPotion(IForgeRegistry<Potion> registry, Potion potion) {
        potion.setRegistryName(new ResourceLocation("growthcraft_cellar", potion.func_76393_a()));
        registry.register((IForgeRegistryEntry)potion);
    }

    public static void registerRecipes() {
        Init.registerCraftingRecipes();
    }

    private static void registerCraftingRecipes() {
    }
}

