/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.PlayerDeathEvent;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeathEvents {
    public DeathEvents() {
        de.maxhenkel.gravestone.corelib.death.DeathEvents.register();
    }

    @SubscribeEvent
    public void playerDeath(PlayerDeathEvent event) {
        TileEntity tileentity;
        event.storeDeath();
        Death death = event.getDeath();
        ServerPlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (DeathEvents.keepInventory((PlayerEntity)player)) {
            return;
        }
        BlockPos graveStoneLocation = GraveUtils.getGraveStoneLocation(world, death.getBlockPos());
        if (((Boolean)Main.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            player.field_71071_by.func_70441_a(Main.OBITUARY.toStack(death));
        }
        if (graveStoneLocation == null) {
            Main.LOGGER.info("Grave of '{}' can't be placed (No space)", (Object)death.getPlayerName());
            Main.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        world.func_175656_a(graveStoneLocation, (BlockState)Main.GRAVESTONE.func_176223_P().func_206870_a((Property)GraveStoneBlock.FACING, (Comparable)player.func_174811_aO().func_176734_d()));
        if (GraveUtils.isReplaceable(world, graveStoneLocation.func_177977_b())) {
            world.func_175656_a(graveStoneLocation.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        }
        if (!((tileentity = world.func_175625_s(graveStoneLocation)) instanceof GraveStoneTileEntity)) {
            Main.LOGGER.info("Grave of '{}' can't be filled with loot (No tileentity found)", (Object)death.getPlayerName());
            Main.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        GraveStoneTileEntity gravestone = (GraveStoneTileEntity)tileentity;
        gravestone.setDeath(death);
        event.removeDrops();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!((Boolean)Main.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (DeathEvents.keepInventory(event.getPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof ObituaryItem)) continue;
            event.getPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    public static boolean keepInventory(PlayerEntity player) {
        try {
            return player.func_130014_f_().func_72912_H().func_82574_x().func_223586_b(GameRules.field_223600_c);
        }
        catch (Exception e) {
            return false;
        }
    }
}

