/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.potions;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.potions.BasePotion;
import com.theundertaker11.geneticsreborn.potions.ComplexBrew;
import com.theundertaker11.geneticsreborn.potions.EffectPotion;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GRPotions {
    public static final Potion SUBSTRATE_EFFECT = new BasePotion("geneticsreborn:substrate", false, 1533470);
    public static final Potion GROWTH_EFFECT = new BasePotion("geneticsreborn:growth", false, 9825076);
    public static final Potion MUTATION_EFFECT = new BasePotion("geneticsreborn:mutation", false, 6032688);
    public static final Potion VIRAL_EFFECT = new BasePotion("geneticsreborn:viral", false, 13733403);
    public static final Potion BLEED_EFFECT = new EffectPotion("geneticsreborn:bleed", true, 6032688, 0, 0);
    public static final Potion CURE_EFFECT = new EffectPotion("geneticsreborn:cure", true, 11022979, 1, 0);
    public static final PotionType SUBSTRATE = (PotionType)new PotionType("geneticsreborn:substrate", new PotionEffect[]{new PotionEffect(SUBSTRATE_EFFECT, 0)}).setRegistryName("geneticsreborn:substrate");
    public static final PotionType GROWTH_POTION = (PotionType)new PotionType("geneticsreborn:growth", new PotionEffect[]{new PotionEffect(GROWTH_EFFECT, 0)}).setRegistryName("geneticsreborn:growth");
    public static final PotionType MUTATION_POTION = (PotionType)new PotionType("geneticsreborn:mutation", new PotionEffect[]{new PotionEffect(MUTATION_EFFECT, 0)}).setRegistryName("geneticsreborn:mutation");
    public static final PotionType VIRAL_POTION = (PotionType)new PotionType("geneticsreborn:viral", new PotionEffect[]{new PotionEffect(VIRAL_EFFECT, 0)}).setRegistryName("geneticsreborn:viral");
    public static final PotionType CURE_POTION = (PotionType)new PotionType("geneticsreborn:cure", new PotionEffect[]{new PotionEffect(CURE_EFFECT, 1200)}).setRegistryName("geneticsreborn:cure");

    public static void init() {
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)SUBSTRATE_EFFECT);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)GROWTH_EFFECT);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)MUTATION_EFFECT);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)VIRAL_EFFECT);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)BLEED_EFFECT);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)CURE_EFFECT);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)SUBSTRATE);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)GROWTH_POTION);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)MUTATION_POTION);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)VIRAL_POTION);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)CURE_POTION);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(PotionTypes.field_185231_c, GRItems.OrganicMatter, null, PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)SUBSTRATE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(SUBSTRATE, GRItems.DNAHelix, "GeneticsRebornBasicGene", PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)GROWTH_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.EMERALD_HEART.toGeneName(), PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)CURE_POTION)));
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)CURE_POTION), (ItemStack)new ItemStack(Items.field_151016_H, 1), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.ViralPotion), (PotionType)CURE_POTION));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(SUBSTRATE, GRItems.Cell, null, new ItemStack(GRItems.Cell, 1)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, GRItems.Cell, null, PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)GROWTH_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151114_aO, "EntityBlaze", EnumGenes.BIOLUMIN, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151114_aO, "EntityMagmaCube", EnumGenes.BIOLUMIN, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151166_bC, "EntityVillager", EnumGenes.EMERALD_HEART, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151166_bC, "EntityShulker", EnumGenes.SAVE_INVENTORY, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151137_ax, "EntityRabbit", EnumGenes.SPEED, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151034_e, "EntityIronGolem", EnumGenes.MORE_HEARTS, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151153_ao, "EntityVillager", EnumGenes.REGENERATION, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151110_aK, "EntityChicken", EnumGenes.LAY_EGG, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151147_al, "EntityPig", EnumGenes.MEATY, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151079_bi, "EntityEnderman", EnumGenes.TELEPORTER, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151042_j, "EntityEnderman", EnumGenes.ITEM_MAGNET, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151153_ao, "EntityEnderman", EnumGenes.MORE_HEARTS, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151114_aO, "EntitySlime", EnumGenes.PHOTOSYNTHESIS, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(GROWTH_POTION, Items.field_151071_bq, null, PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)MUTATION_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, GRItems.Cell, null, PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)MUTATION_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151102_aT, "*", "GeneticsRebornMutatedGene", 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151008_G, "EntityBat", EnumGenes.FLY, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151008_G, "EntityParrot", EnumGenes.FLY, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151166_bC, "EntityPolarBear", EnumGenes.STRENGTH, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151166_bC, "EntityLlama", EnumGenes.STRENGTH, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151166_bC, "EntityRabbit", EnumGenes.LUCK, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151045_i, "EntityShulker", EnumGenes.RESISTANCE, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151045_i, "EntityZombie", EnumGenes.RESISTANCE, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151045_i, "EntityPolarBear", EnumGenes.CLAWS, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151045_i, "EntityLlama", EnumGenes.CLAWS, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151045_i, "EntityWolf", EnumGenes.CLAWS, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151137_ax, "EntityRabbit", EnumGenes.SPEED_2, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151137_ax, "EntityOcelot", EnumGenes.SPEED_4, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151042_j, "EntityRabbit", EnumGenes.HASTE, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151137_ax, "EntitySilverfish", EnumGenes.EFFICIENCY, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151070_bp, "EntityZombie", EnumGenes.SCARE_CREEPERS, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151070_bp, "EntitySpider", EnumGenes.SCARE_SKELETONS, 75));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151137_ax, "Ender Dragon", EnumGenes.REGENERATION, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151065_br, "EntityPig", EnumGenes.MEATY, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151061_bv, "EntityBat", EnumGenes.INVISIBLE, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151061_bv, "EntitySkeleton", EnumGenes.INVISIBLE, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_151153_ao, "EntityEnderman", EnumGenes.MORE_HEARTS, 50));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(MUTATION_POTION, Items.field_185161_cS, null, PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.GRPotion), (PotionType)VIRAL_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.POISON_PROOF, EnumGenes.POISON, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.WITHER_HIT, EnumGenes.POISON_4, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.WITHER_PROOF, EnumGenes.WITHER, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.STRENGTH, EnumGenes.WEAKNESS, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.NIGHT_VISION, EnumGenes.BLINDNESS, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.SPEED, EnumGenes.SLOWNESS, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.SPEED_2, EnumGenes.SLOWNESS_4, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.SPEED_4, EnumGenes.SLOWNESS_6, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.MILKY, EnumGenes.NAUSEA, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.MEATY, EnumGenes.NAUSEA, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.LAY_EGG, EnumGenes.NAUSEA, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.NO_HUNGER, EnumGenes.HUNGER, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.FIRE_PROOF, EnumGenes.FLAME, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.LUCK, EnumGenes.CURSED, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.HASTE, EnumGenes.MINING_WEAKNESS, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.SCARE_CREEPERS, EnumGenes.DEAD_CREEPERS, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.SCARE_ZOMBIES, EnumGenes.DEAD_UNDEAD, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.SCARE_SKELETONS, EnumGenes.DEAD_UNDEAD, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.RESISTANCE, EnumGenes.DEAD_OLD_AGE, 100));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.DNAHelix, EnumGenes.DRAGONS_BREATH, EnumGenes.DEAD_HOSTILE, 100));
        if (GeneticsReborn.enableBlackDeath) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrew(VIRAL_POTION, GRItems.GlassSyringe, EnumGenes.DEAD_ALL, EnumGenes.DEAD_ALL, 100));
        }
    }

    @SubscribeEvent
    public void handleCurePotion(TickEvent.WorldTickEvent event) {
        for (Entity ent : event.world.field_72996_f) {
            EntityLivingBase e;
            if (!(ent instanceof EntityLivingBase) || !(e = (EntityLivingBase)ent).func_70644_a(CURE_EFFECT)) continue;
            if (e instanceof EntityPlayer) {
                this.cureEntity(e);
                continue;
            }
            if (e instanceof EntityVillager) {
                this.cureEntity(e);
                continue;
            }
            if (!(e instanceof EntityZombieVillager)) continue;
            this.cureZombieVillager((EntityZombieVillager)e);
        }
    }

    private void cureZombieVillager(EntityZombieVillager e) {
        if (e.func_82230_o()) {
            return;
        }
        Class[] args = new Class[]{UUID.class, Integer.TYPE};
        try {
            Method m = e.getClass().getDeclaredMethod("startConverting", args);
            m.setAccessible(true);
            m.invoke((Object)e, null, 20);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cureEntity(EntityLivingBase e) {
        IGenes genes = ModUtils.getIGenes((Entity)e);
        for (EnumGenes gene : genes.getGeneList()) {
            if (!gene.isNegative()) continue;
            genes.removeGene(gene);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() == Items.field_151068_bn || event.getItemStack().func_77973_b() == GRItems.GRPotion) {
            EnumGenes gene;
            NBTTagCompound tag = event.getItemStack().func_77978_p();
            if (tag == null || tag.func_74779_i("Potion") == null) {
                return;
            }
            if (tag.func_74779_i("Potion").equals(GROWTH_POTION.getRegistryName().toString()) && tag.func_74764_b("entityName")) {
                event.getToolTip().add("(" + tag.func_74779_i("entityName") + ")");
            }
            if (tag.func_74779_i("Potion").equals(MUTATION_POTION.getRegistryName().toString()) && tag.func_74764_b("entityName")) {
                event.getToolTip().add("(" + tag.func_74779_i("entityName") + ")");
            }
            if (tag.func_74779_i("Potion").equals(VIRAL_POTION.getRegistryName().toString()) && tag.func_74764_b("gene") && (gene = EnumGenes.fromGeneName(tag.func_74779_i("gene"))) != null) {
                event.getToolTip().add("(" + gene.getDescription() + ")");
            }
        }
    }
}

