/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.event;

import com.theundertaker11.geneticsreborn.api.capability.CapabilityHandler;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.event.AIChangeEvents;
import com.theundertaker11.geneticsreborn.event.DeathRelatedEvents;
import com.theundertaker11.geneticsreborn.event.OnEntityHurt;
import com.theundertaker11.geneticsreborn.event.OnRightClick;
import com.theundertaker11.geneticsreborn.event.OnWorldTickEvent;
import com.theundertaker11.geneticsreborn.event.PlayerTickEvent;
import com.theundertaker11.geneticsreborn.event.RightClickEntityEvent;
import com.theundertaker11.geneticsreborn.keybinds.KeybindHandler;
import com.theundertaker11.geneticsreborn.packets.GeneticsRebornPacketHandler;
import com.theundertaker11.geneticsreborn.packets.SendShootDragonBreath;
import com.theundertaker11.geneticsreborn.packets.SendTeleportPlayer;
import com.theundertaker11.geneticsreborn.potions.GRPotions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GREventHandler {
    public static int flightticktimer;
    public static Map<String, Long> cooldownList;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GREventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RightClickEntityEvent());
        MinecraftForge.EVENT_BUS.register((Object)new OnWorldTickEvent());
        MinecraftForge.EVENT_BUS.register((Object)new OnRightClick());
        MinecraftForge.EVENT_BUS.register((Object)new OnEntityHurt());
        MinecraftForge.EVENT_BUS.register((Object)new DeathRelatedEvents());
        MinecraftForge.EVENT_BUS.register((Object)new AIChangeEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTickEvent());
        MinecraftForge.EVENT_BUS.register((Object)new GRPotions());
    }

    @SubscribeEvent
    public void GameTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && flightticktimer < 100) {
            ++flightticktimer;
        }
    }

    public static boolean isInCooldown(EntityLivingBase elb, String type, long now) {
        return !cooldownList.isEmpty() && cooldownList.containsKey(GREventHandler.getCooldownString(elb, type)) && !GREventHandler.isCooldownExpired(elb, type, now, true);
    }

    public static boolean isCooldownExpired(EntityLivingBase elb, String type, long now, boolean remove) {
        if (cooldownList.isEmpty()) {
            return false;
        }
        String key = GREventHandler.getCooldownString(elb, type);
        Long time = cooldownList.get(key);
        if (time == null) {
            time = 0L;
        }
        if (time < now) {
            if (remove) {
                cooldownList.remove(key);
            }
            return true;
        }
        return false;
    }

    public static void addCooldown(EntityLivingBase elb, String type, long now, int duration) {
        String name = GREventHandler.getCooldownString(elb, type);
        cooldownList.put(name, now + (long)duration);
    }

    private static final String getCooldownString(EntityLivingBase elb, String type) {
        return elb.func_110124_au().toString() + "/" + type;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (EnumGenes.TELEPORTER.isActive() && KeybindHandler.keybindTeleport.func_151468_f()) {
            GeneticsRebornPacketHandler.INSTANCE.sendToServer((IMessage)new SendTeleportPlayer());
        }
        if (EnumGenes.DRAGONS_BREATH.isActive() && KeybindHandler.keybindDragonsBreath.func_151468_f()) {
            GeneticsRebornPacketHandler.INSTANCE.sendToServer((IMessage)new SendShootDragonBreath());
        }
    }

    static {
        cooldownList = new HashMap<String, Long>();
    }
}

