/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.api.capability;

import com.theundertaker11.geneticsreborn.api.capability.genes.GeneCapabilityProvider;
import com.theundertaker11.geneticsreborn.api.capability.genes.Genes;
import com.theundertaker11.geneticsreborn.api.capability.genes.GenesStorage;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.IMaxHealth;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.MaxHealth;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.MaxHealthCapabilityProvider;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.MaxHealthStorage;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityHandler {
    public static final ResourceLocation GENES_CAPABILITY = new ResourceLocation("geneticsreborn", "genes");
    public static final ResourceLocation MAXHEALTH_CAPABILITY = new ResourceLocation("geneticsreborn", "maxhealth");

    public static void init() {
        CapabilityManager.INSTANCE.register(IMaxHealth.class, (Capability.IStorage)new MaxHealthStorage(), MaxHealth.class);
        CapabilityManager.INSTANCE.register(IGenes.class, (Capability.IStorage)new GenesStorage(), Genes.class);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase && event.getObject() != null) {
            event.addCapability(GENES_CAPABILITY, (ICapabilityProvider)new GeneCapabilityProvider());
            MaxHealth maxHealth = new MaxHealth((EntityLivingBase)event.getObject());
            event.addCapability(MAXHEALTH_CAPABILITY, (ICapabilityProvider)new MaxHealthCapabilityProvider(maxHealth));
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        IMaxHealth maxHealth = ModUtils.getIMaxHealth((EntityLivingBase)event.player);
        if (maxHealth != null) {
            maxHealth.synchronise();
        }
    }
}

