/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.world.gen;

import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeFactory;
import com.jaquadro.minecraft.gardentrees.world.gen.WorldGenOrnamentalTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public abstract class WorldGenStandardOrnTree
extends WorldGenOrnamentalTree {
    protected List<String> layers = new ArrayList<String>();

    public WorldGenStandardOrnTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
        super(blockNotify, wood, metaWood, leaves, metaLeaves);
    }

    @Override
    protected boolean canGenerateCanopy(World world, int x, int y, int z, int trunkHeight) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (this.canGeneratePattern(world, x, y + trunkHeight + i, z, this.layers.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void generateCanopy(World world, int x, int y, int z, int trunkHeight) {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.generatePattern(world, x, y + trunkHeight + i, z, this.layers.get(i));
        }
    }

    public static class SmallCanopyTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallCanopyTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallCanopyTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
        }

        @Override
        protected void prepare(World world, Random rand, int x, int y, int z, int trunkHeight) {
            this.layers = new ArrayList();
            this.layers.add(SmallCanopyTree.transform(" 0 1X2 3 ", WorldGenOrnamentalTree.LayerType.TRUNK, rand.nextInt()));
            this.layers.add(SmallCanopyTree.transform(" XXX XXXXXXXTXXXXXXX XXX ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(SmallCanopyTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallCyprusTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallCyprusTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallCyprusTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallCyprusTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE), SmallCyprusTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE), SmallCyprusTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF), SmallCyprusTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF), SmallCyprusTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class LargeSpruceTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new LargeSpruceTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public LargeSpruceTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
        }

        @Override
        protected void prepare(World world, Random rand, int x, int y, int z, int trunkHeight) {
            this.layers = new ArrayList();
            this.layers.add(LargeSpruceTree.transform("T", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(LargeSpruceTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(LargeSpruceTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(LargeSpruceTree.transform("  X   XXX XXTXX XXX   X  ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(LargeSpruceTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(LargeSpruceTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(LargeSpruceTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF));
            this.layers.add(LargeSpruceTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class TallSmallOakTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new TallSmallOakTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public TallSmallOakTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(TallSmallOakTree.transform("T", WorldGenOrnamentalTree.LayerType.TRUNK), TallSmallOakTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE), TallSmallOakTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE), TallSmallOakTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallShrubTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallShrubTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallShrubTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallShrubTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF), SmallShrubTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallMahoganyTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallMahoganyTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallMahoganyTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallMahoganyTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.TRUNK), SmallMahoganyTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.LEAF), SmallMahoganyTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallPineTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallPineTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallPineTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
        }

        @Override
        protected void prepare(World world, Random rand, int x, int y, int z, int trunkHeight) {
            this.layers = new ArrayList();
            this.layers.add(SmallPineTree.transform("0X XTX X ", WorldGenOrnamentalTree.LayerType.CORE, rand.nextInt()));
            this.layers.add(SmallPineTree.transform("T", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(SmallPineTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(SmallPineTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallWillowTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallWillowTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallWillowTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallWillowTree.transform("X X T X X", WorldGenOrnamentalTree.LayerType.CORE), SmallWillowTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE), SmallWillowTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallPalmTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallPalmTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallPalmTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallPalmTree.transform("T", WorldGenOrnamentalTree.LayerType.CORE), SmallPalmTree.transform("X X T X X", WorldGenOrnamentalTree.LayerType.CORE), SmallPalmTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class LargeOakTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new LargeOakTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public LargeOakTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(LargeOakTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE), LargeOakTree.transform("  X   XXX XXTXX XXX   X  ", WorldGenOrnamentalTree.LayerType.CORE), LargeOakTree.transform(" XXX XXTXXXTTTXXXTXX XXX ", WorldGenOrnamentalTree.LayerType.CORE), LargeOakTree.transform("  X   XXX XXTXX XXX   X  ", WorldGenOrnamentalTree.LayerType.CORE), LargeOakTree.transform(" X X XXXXX XTX XXXXX X X ", WorldGenOrnamentalTree.LayerType.CORE), LargeOakTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallAcaciaTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallAcaciaTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallAcaciaTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallAcaciaTree.transform("T", WorldGenOrnamentalTree.LayerType.CORE), SmallAcaciaTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE), SmallAcaciaTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallJungleTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallJungleTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallJungleTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
        }

        @Override
        protected void prepare(World world, Random rand, int x, int y, int z, int trunkHeight) {
            this.layers = new ArrayList();
            this.layers.add(SmallJungleTree.transform(" 00  0XXX 0XTX  XXX      ", WorldGenOrnamentalTree.LayerType.CORE, rand.nextInt()));
            this.layers.add(SmallJungleTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(SmallJungleTree.transform(" 00  0XXX 0XTX  XXX      ", WorldGenOrnamentalTree.LayerType.CORE));
            this.layers.add(SmallJungleTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallSpruceTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallSpruceTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallSpruceTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallSpruceTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE), SmallSpruceTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE), SmallSpruceTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF), SmallSpruceTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }

    public static class SmallOakTree
    extends WorldGenStandardOrnTree {
        public static final OrnamentalTreeFactory FACTORY = new OrnamentalTreeFactory(){

            @Override
            public WorldGenOrnamentalTree create(Block woodBlock, int woodMeta, Block leafBlock, int leafMeta) {
                return new SmallOakTree(false, woodBlock, woodMeta, leafBlock, leafMeta);
            }
        };

        public SmallOakTree(boolean blockNotify, Block wood, int metaWood, Block leaves, int metaLeaves) {
            super(blockNotify, wood, metaWood, leaves, metaLeaves);
            this.layers = Arrays.asList(SmallOakTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.CORE), SmallOakTree.transform("XXXXTXXXX", WorldGenOrnamentalTree.LayerType.CORE), SmallOakTree.transform(" X XTX X ", WorldGenOrnamentalTree.LayerType.LEAF), SmallOakTree.transform("T", WorldGenOrnamentalTree.LayerType.LEAF));
        }
    }
}

