/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.integration;

import com.jaquadro.minecraft.gardencore.api.SaplingRegistry;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeFactory;
import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class WitcheryIntegration {
    public static final String MOD_ID = "witchery";

    public static void init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        HashMap<String, int[]> saplingBank1 = new HashMap<String, int[]>();
        saplingBank1.put("small_oak", new int[]{0, 1, 2});
        HashMap<Item, HashMap<String, int[]>> banks = new HashMap<Item, HashMap<String, int[]>>();
        banks.put(Item.func_150898_a((Block)GameRegistry.findBlock((String)MOD_ID, (String)"witchsapling")), saplingBank1);
        SaplingRegistry saplingReg = SaplingRegistry.instance();
        for (Map.Entry entry : banks.entrySet()) {
            Item sapling = (Item)entry.getKey();
            for (Map.Entry bankEntry : ((Map)entry.getValue()).entrySet()) {
                OrnamentalTreeFactory factory = OrnamentalTreeRegistry.getTree((String)bankEntry.getKey());
                if (factory == null) continue;
                for (int i : (int[])bankEntry.getValue()) {
                    UniqueMetaIdentifier woodBlock = saplingReg.getWoodForSapling(sapling, i);
                    UniqueMetaIdentifier leafBlock = saplingReg.getLeavesForSapling(sapling, i);
                    if (woodBlock == null && leafBlock == null) continue;
                    saplingReg.putExtendedData(sapling, i, "sm_generator", (Object)factory.create(woodBlock.getBlock(), woodBlock.meta, leafBlock.getBlock(), leafBlock.meta));
                }
            }
        }
    }
}

