/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.integration;

import com.jaquadro.minecraft.gardencore.api.GardenCoreAPI;
import com.jaquadro.minecraft.gardencore.api.IBonemealHandler;
import com.jaquadro.minecraft.gardencore.api.SaplingRegistry;
import com.jaquadro.minecraft.gardencore.api.WoodRegistry;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardentrees.core.ModBlocks;
import com.jaquadro.minecraft.gardentrees.world.gen.WorldGenStandardOrnTree;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.oredict.OreDictionary;

public class GardenCoreIntegration {
    public static final String MOD_ID = "GardenCore";

    public static void init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        SaplingRegistry saplingReg = SaplingRegistry.instance();
        Item sapling = Item.func_150898_a((Block)Blocks.field_150345_g);
        saplingReg.putExtendedData(sapling, 0, "sm_generator", (Object)WorldGenStandardOrnTree.SmallOakTree.FACTORY.create(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0));
        saplingReg.putExtendedData(sapling, 1, "sm_generator", (Object)WorldGenStandardOrnTree.SmallSpruceTree.FACTORY.create(Blocks.field_150364_r, 1, (Block)Blocks.field_150362_t, 1));
        saplingReg.putExtendedData(sapling, 2, "sm_generator", (Object)WorldGenStandardOrnTree.SmallOakTree.FACTORY.create(Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2));
        saplingReg.putExtendedData(sapling, 3, "sm_generator", (Object)WorldGenStandardOrnTree.SmallJungleTree.FACTORY.create(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3));
        saplingReg.putExtendedData(sapling, 4, "sm_generator", (Object)WorldGenStandardOrnTree.SmallAcaciaTree.FACTORY.create(Blocks.field_150363_s, 0, (Block)Blocks.field_150361_u, 0));
        saplingReg.putExtendedData(sapling, 5, "sm_generator", (Object)WorldGenStandardOrnTree.SmallOakTree.FACTORY.create(Blocks.field_150363_s, 1, (Block)Blocks.field_150361_u, 1));
        Item extSapling = Item.func_150898_a((Block)ModBlocks.sapling);
        saplingReg.registerSapling(extSapling, 0, Blocks.field_150364_r, 1, (Block)Blocks.field_150362_t, 1);
        saplingReg.registerSapling(extSapling, 1, Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0);
        saplingReg.registerSapling(extSapling, 2, Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2);
        saplingReg.putExtendedData(extSapling, 0, "sm_generator", (Object)WorldGenStandardOrnTree.SmallSpruceTree.FACTORY.create(Blocks.field_150364_r, 1, (Block)Blocks.field_150362_t, 1));
        saplingReg.putExtendedData(extSapling, 1, "sm_generator", (Object)WorldGenStandardOrnTree.SmallOakTree.FACTORY.create(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0));
        saplingReg.putExtendedData(extSapling, 2, "sm_generator", (Object)WorldGenStandardOrnTree.SmallOakTree.FACTORY.create(Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2));
        GardenCoreAPI.instance().registerBonemealHandler(new GardenBonemealHandler());
        WoodRegistry woodRegistry = WoodRegistry.instance();
        ArrayList woodList = OreDictionary.getOres((String)"treeWood");
        for (ItemStack item : woodList) {
            if (item == null) continue;
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            woodRegistry.registerWoodType(block, item.func_77960_j());
        }
    }

    private static class GardenBonemealHandler
    implements IBonemealHandler {
        private GardenBonemealHandler() {
        }

        @Override
        public boolean applyBonemeal(World world, int x, int y, int z, BlockGarden hostBlock, int slot) {
            Block plantBlock = hostBlock.getPlantBlockFromSlot((IBlockAccess)world, x, y, z, slot);
            if (plantBlock == null) {
                return false;
            }
            Item sapling = Item.func_150898_a((Block)plantBlock);
            int saplingMeta = hostBlock.getPlantMetaFromSlot((IBlockAccess)world, x, y, z, slot);
            WorldGenerator generator = (WorldGenerator)SaplingRegistry.instance().getExtendedData(sapling, saplingMeta, "sm_generator");
            if (generator == null) {
                return false;
            }
            NBTTagCompound storedTE = hostBlock.saveAndClearPlantedContents((IBlockAccess)world, x, y, z);
            if (!generator.func_76484_a(world, world.field_73012_v, x, y + 1, z)) {
                hostBlock.restorePlantedContents((IBlockAccess)world, x, y, z, storedTE);
            }
            return true;
        }
    }
}

