/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.block.tile;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityWoodProxy
extends TileEntity {
    private Block protoBlock;
    private int protoMeta;

    public Block getProtoBlock() {
        return this.protoBlock;
    }

    public int getProtoMeta() {
        return this.protoMeta;
    }

    public void setProtoBlock(Block block, int meta) {
        this.protoBlock = block;
        this.protoMeta = meta;
    }

    public static int composeMetadata(Block block, int meta) {
        int id = GameData.blockRegistry.getId((Object)block);
        return id & 0xFFF | (meta & 0xF) << 12;
    }

    public static Block getBlockFromComposedMetadata(int metadata) {
        if (metadata >= 16) {
            return (Block)GameData.blockRegistry.get(metadata & 0xFFF);
        }
        if (metadata < 4) {
            return Blocks.field_150364_r;
        }
        if (metadata < 8) {
            return Blocks.field_150363_s;
        }
        return null;
    }

    public static int getMetaFromComposedMetadata(int metadata) {
        if (metadata >= 16) {
            return metadata >> 12 & 0xF;
        }
        return metadata % 4;
    }

    public static void syncTileEntityWithData(World world, int x, int y, int z, int metadata) {
        if (metadata < 16) {
            world.func_147475_p(x, y, z);
            return;
        }
        TileEntityWoodProxy te = (TileEntityWoodProxy)world.func_147438_o(x, y, z);
        if (te == null) {
            te = new TileEntityWoodProxy();
            world.func_147455_a(x, y, z, (TileEntity)te);
        }
        Block block = TileEntityWoodProxy.getBlockFromComposedMetadata(metadata);
        int protoMeta = TileEntityWoodProxy.getMetaFromComposedMetadata(metadata);
        if (block != null) {
            te.setProtoBlock(block, protoMeta);
        }
        te.func_70296_d();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.protoBlock != null) {
            tag.func_74768_a("P", this.getUnifiedProtoData());
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("P")) {
            this.unpackUnifiedProtoData(tag.func_74762_e("P"));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private int getUnifiedProtoData() {
        return Block.func_149682_b((Block)this.protoBlock) & 0xFFFF | (this.protoMeta & 0xFFFF) << 16;
    }

    private void unpackUnifiedProtoData(int protoData) {
        this.protoBlock = Block.func_149729_e((int)(protoData & 0xFFFF));
        this.protoMeta = protoData >> 16 & 0xFFFF;
    }
}

