/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.block;

import com.jaquadro.minecraft.gardentrees.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockGTSapling
extends BlockSapling {
    public static final String[] types = new String[]{"pine", "swamp", "tallbirch"};
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] icons;

    public BlockGTSapling(String name) {
        this.func_149663_c(name);
        this.func_149658_d("sapling");
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a(ModCreativeTabs.tabGardenTrees);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return icons[MathHelper.func_76125_a((int)(meta &= 7), (int)0, (int)(types.length - 1))];
    }

    public void func_149878_d(World world, int x, int y, int z, Random random) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)random, (int)x, (int)y, (int)z)) {
            return;
        }
        int id = world.func_72805_g(x, y, z) & 7;
        Object generator = null;
        switch (id) {
            case 0: {
                generator = new WorldGenTaiga1(){

                    protected void func_150516_a(World world, int x, int y, int z, Block block, int meta) {
                        world.func_147465_d(x, y, z, block, meta, 3);
                    }
                };
                break;
            }
            case 1: {
                generator = new WorldGenSwamp(){

                    protected void func_150516_a(World world, int x, int y, int z, Block block, int meta) {
                        world.func_147465_d(x, y, z, block, meta, 3);
                    }
                };
                break;
            }
            case 2: {
                generator = new WorldGenForest(true, true);
                break;
            }
            default: {
                return;
            }
        }
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        if (!generator.func_76484_a(world, random, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, id, 4);
        }
    }

    public int func_149692_a(int meta) {
        return MathHelper.func_76125_a((int)(meta & 7), (int)0, (int)types.length);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }

    public void func_149651_a(IIconRegister register) {
        icons = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            BlockGTSapling.icons[i] = register.func_94245_a("GardenTrees:" + this.func_149641_N() + "_" + types[i]);
        }
    }
}

