/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.block;

import com.jaquadro.minecraft.gardentrees.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardentrees.core.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IShearable;

public class BlockCandelilla
extends BlockCrops
implements IShearable {
    @SideOnly(value=Side.CLIENT)
    IIcon[] icons;
    private boolean shearScratch;

    public BlockCandelilla(String blockName) {
        this.func_149658_d("GardenTrees:candelilla");
        this.func_149663_c(blockName);
        this.func_149711_c(0.0f);
        this.func_149672_a(BlockBush.field_149779_h);
        this.func_149647_a(ModCreativeTabs.tabGardenTrees);
    }

    public int func_149645_b() {
        return 6;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        this.shearScratch = true;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        return ret;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (this.shearScratch) {
            this.shearScratch = false;
            return false;
        }
        return super.canHarvestBlock(player, meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.icons[0];
            }
            case 1: {
                return this.icons[1];
            }
            case 2: {
                return this.icons[2];
            }
            case 3: 
            case 4: {
                return this.icons[3];
            }
            case 5: 
            case 6: {
                return this.icons[4];
            }
        }
        return this.icons[5];
    }

    protected Item func_149866_i() {
        return ModItems.candelilla_seeds;
    }

    protected Item func_149865_P() {
        return ModItems.candelilla;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (super.func_149718_j(world, x, y, z)) {
            return true;
        }
        return this.func_149854_a(world.func_147439_a(x, y - 1, z));
    }

    protected boolean func_149854_a(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150354_m;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[6];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a(this.func_149641_N() + "_stage_" + i);
        }
    }
}

