/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.item;

import com.jaquadro.minecraft.gardenapi.api.component.ILanternSource;
import com.jaquadro.minecraft.gardenapi.internal.Api;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityLantern;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemLantern
extends ItemBlock {
    public ItemLantern(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata & 0xF)) {
            return false;
        }
        TileEntityLantern tile = (TileEntityLantern)world.func_147438_o(x, y, z);
        if (tile != null) {
            tile.setHasGlass(ModBlocks.lantern.isGlass(stack));
            tile.setLightSourceMeta(ModBlocks.lantern.getLightSourceMeta(stack));
            tile.setLightSource(ModBlocks.lantern.getLightSource(stack));
        }
        if (world.func_147439_a(x, y + 1, z) == ModBlocks.heavyChain) {
            world.func_147460_e(x, y + 1, z, world.func_147439_a(x, y, z));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (ModBlocks.lantern.isGlass(itemStack)) {
            String glassName = Blocks.field_150399_cn.func_149739_a() + "." + ItemDye.field_150923_a[BlockColored.func_150032_b((int)itemStack.func_77960_j())];
            list.add(StatCollector.func_74838_a((String)(glassName + ".name")));
        }
        String contents = StatCollector.func_74838_a((String)ModBlocks.makeName("lanternSource")) + ": " + EnumChatFormatting.YELLOW;
        String source = ModBlocks.lantern.getLightSource(itemStack);
        ILanternSource lanternSource = source != null ? Api.instance.registries().lanternSources().getLanternSource(source) : null;
        contents = lanternSource != null ? contents + StatCollector.func_74838_a((String)lanternSource.getLanguageKey(itemStack.func_77960_j())) : contents + StatCollector.func_74838_a((String)ModBlocks.makeName("lanternSource.none"));
        list.add(contents);
    }

    public ItemStack makeItemStack(int count, int meta, boolean hasGlass) {
        return this.makeItemStack(count, meta, hasGlass, null);
    }

    public ItemStack makeItemStack(int count, int meta, boolean hasGlass, String source) {
        return this.makeItemStack(count, meta, hasGlass, source, 0);
    }

    public ItemStack makeItemStack(int count, int meta, boolean hasGlass, String source, int sourceMeta) {
        ItemStack stack = new ItemStack((Item)this, count, meta);
        NBTTagCompound tag = new NBTTagCompound();
        if (hasGlass) {
            tag.func_74757_a("glass", true);
        }
        if (source != null) {
            tag.func_74778_a("src", source);
        }
        if (sourceMeta != 0) {
            tag.func_74777_a("srcMeta", (short)sourceMeta);
        }
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }
}

