/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.integration.minetweaker;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.machine.ICompostMaterial;
import com.jaquadro.minecraft.gardenapi.api.machine.StandardCompostMaterial;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gardenstuff.CompostBin")
public class CompostBin {
    @ZenMethod
    public static void add(IItemStack item) {
        CompostBin.add(item, 150);
    }

    @ZenMethod
    public static void add(IItemStack item, int processTime) {
        ItemStack stack = MineTweakerMC.getItemStack((IItemStack)item);
        if (stack != null && stack.func_77973_b() != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddItemAction(stack, processTime));
        } else {
            MineTweakerAPI.logError((String)"Tried to add invalid item to compost table.");
        }
    }

    @ZenMethod
    public static void add(String oredictKey) {
        CompostBin.add(oredictKey, 150);
    }

    @ZenMethod
    public static void add(String oredictKey, int processTime) {
        if (oredictKey != null && oredictKey.length() > 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddOreAction(oredictKey, processTime));
        } else {
            MineTweakerAPI.logError((String)"Tried to add empty ore dictionary key to compost table.");
        }
    }

    @ZenMethod
    public static void clear() {
        MineTweakerAPI.apply((IUndoableAction)new ClearAction());
    }

    private static class ClearAction
    implements IUndoableAction {
        private ClearAction() {
        }

        public void apply() {
            GardenAPI.instance().registries().compost().clear();
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Clearing compost table.";
        }

        public String describeUndo() {
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddOreAction
    implements IUndoableAction {
        private String material;
        private int processTime;

        public AddOreAction(String material, int processTime) {
            this.material = material;
            this.processTime = processTime > 0 ? processTime : 150;
        }

        public void apply() {
            GardenAPI.instance().registries().compost().registerCompostMaterial(this.material, (ICompostMaterial)new StandardCompostMaterial(this.processTime, 0.125f));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            GardenAPI.instance().registries().compost().removeCompostMaterial(this.material);
        }

        public String describe() {
            return "Adding ore dictionary key '" + this.material + "' to compost table with processing time '" + this.processTime + "'";
        }

        public String describeUndo() {
            return "Removing previously added ore dictionary key '" + this.material + "' from compost table.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddItemAction
    implements IUndoableAction {
        private ItemStack material;
        private int processTime;

        public AddItemAction(ItemStack material, int processTime) {
            this.material = material.func_77946_l();
            this.processTime = processTime > 0 ? processTime : 150;
        }

        public void apply() {
            GardenAPI.instance().registries().compost().registerCompostMaterial(this.material, (ICompostMaterial)new StandardCompostMaterial(this.processTime, 0.125f));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            GardenAPI.instance().registries().compost().removeCompostMaterial(this.material);
        }

        public String describe() {
            return "Adding item '" + this.material.func_82833_r() + "' to compost table with processing time '" + this.processTime + "'";
        }

        public String describeUndo() {
            return "Removing previously added item '" + this.material.func_82833_r() + "' from compost table.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

