/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.integration;

import com.jaquadro.minecraft.gardencore.api.GardenCoreAPI;
import com.jaquadro.minecraft.gardencore.api.IBonemealHandler;
import com.jaquadro.minecraft.gardencore.api.PlantRegistry;
import com.jaquadro.minecraft.gardencore.api.SaplingRegistry;
import com.jaquadro.minecraft.gardencore.api.WoodRegistry;
import com.jaquadro.minecraft.gardencore.api.plant.IPlantInfo;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.api.plant.SimplePlantInfo;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WitcheryIntegration {
    public static final String MOD_ID = "witchery";

    public static void init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        WitcheryIntegration.initWood();
        GardenCoreAPI.instance().registerBonemealHandler(new BonemealHandler());
        PlantRegistry plantReg = PlantRegistry.instance();
        plantReg.registerPlantInfo(MOD_ID, "embermoss", (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "leapinglily", (IPlantInfo)new SimplePlantInfo(PlantType.AQUATIC_COVER, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "spanishmoss", (IPlantInfo)new SimplePlantInfo(PlantType.HANGING_SIDE, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "bramble", (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        plantReg.registerPlantInfo(MOD_ID, "glintweed", (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "voidbramble", (IPlantInfo)new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        plantReg.registerPlantInfo(MOD_ID, "seedsartichoke", 0, new SimplePlantInfo(PlantType.AQUATIC_SURFACE, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "seedswormwood", 0, new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "seedsmandrake", 0, new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        plantReg.registerPlantInfo(MOD_ID, "seedswolfsbane", 0, new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "seedsbelladonna", 0, new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
        plantReg.registerPlantInfo(MOD_ID, "seedssnowbell", 0, new SimplePlantInfo(PlantType.GROUND, PlantSize.LARGE));
        plantReg.registerPlantInfo(MOD_ID, "garlic", 0, new SimplePlantInfo(PlantType.GROUND, PlantSize.FULL));
    }

    private static void initWood() {
        Block log = GameRegistry.findBlock((String)MOD_ID, (String)"witchlog");
        Block leaf = GameRegistry.findBlock((String)MOD_ID, (String)"witchleaves");
        Item sapling = GameRegistry.findItem((String)MOD_ID, (String)"witchsapling");
        WoodRegistry woodReg = WoodRegistry.instance();
        for (int i = 0; i < 3; ++i) {
            woodReg.registerWoodType(log, i);
        }
        SaplingRegistry saplingReg = SaplingRegistry.instance();
        for (int i = 0; i < 3; ++i) {
            saplingReg.registerSapling(sapling, i, log, i, leaf, i);
        }
    }

    private static class BonemealHandler
    implements IBonemealHandler {
        private BonemealHandler() {
        }

        @Override
        public boolean applyBonemeal(World world, int x, int y, int z, BlockGarden hostBlock, int slot) {
            ItemStack upgrade;
            TileEntityGarden te = hostBlock.getTileEntity((IBlockAccess)world, x, y, z);
            ItemStack plantItem = te.getPlantInSlot(slot);
            if (plantItem == null) {
                return false;
            }
            if (plantItem.func_77960_j() < 4 && (plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"seedsbelladonna") || plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"seedsartichoke") || plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"seedswormwood") || plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"seedsmandrake") || plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"seedssnowbell"))) {
                ItemStack upgrade2 = new ItemStack(plantItem.func_77973_b(), 1, plantItem.func_77960_j() + 1);
                if (hostBlock.isPlantValidForSlot(world, x, y, z, slot, PlantItem.getForItem((IBlockAccess)world, upgrade2))) {
                    te.func_70299_a(slot, upgrade2);
                    return true;
                }
            } else if (plantItem.func_77960_j() < 5 && plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"garlic")) {
                ItemStack upgrade3 = new ItemStack(plantItem.func_77973_b(), 1, plantItem.func_77960_j() + 1);
                if (hostBlock.isPlantValidForSlot(world, x, y, z, slot, PlantItem.getForItem((IBlockAccess)world, upgrade3))) {
                    te.func_70299_a(slot, upgrade3);
                    return true;
                }
            } else if (plantItem.func_77960_j() < 7 && plantItem.func_77973_b() == GameRegistry.findItem((String)WitcheryIntegration.MOD_ID, (String)"seedswolfsbane") && hostBlock.isPlantValidForSlot(world, x, y, z, slot, PlantItem.getForItem((IBlockAccess)world, upgrade = new ItemStack(plantItem.func_77973_b(), 1, plantItem.func_77960_j() + 1)))) {
                te.func_70299_a(slot, upgrade);
                return true;
            }
            return false;
        }
    }
}

