/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.client.renderer.plant;

import com.jaquadro.minecraft.gardencore.api.IPlantMetaResolver;
import com.jaquadro.minecraft.gardencore.api.IPlantRenderer;
import com.jaquadro.minecraft.gardencore.api.PlantRegistry;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class DoublePlantRenderer
implements IPlantRenderer {
    @Override
    public void render(IBlockAccess world, int x, int y, int z, RenderBlocks renderer, Block block, int meta, int height, AxisAlignedBB[] bounds) {
        if (!(block instanceof BlockDoublePlant)) {
            return;
        }
        BlockDoublePlant doublePlant = (BlockDoublePlant)block;
        IPlantMetaResolver resolver = PlantRegistry.instance().getPlantMetaResolver(block, meta);
        if (resolver != null) {
            meta = resolver.getPlantSectionMeta(block, meta, height);
        }
        IIcon iicon = this.getIcon(block, world, meta);
        if (height == 1) {
            for (AxisAlignedBB bound : bounds) {
                RenderHelper.instance.setRenderBounds(bound.field_72340_a, bound.field_72338_b, bound.field_72339_c, bound.field_72336_d, bound.field_72337_e, bound.field_72334_f);
                RenderHelper.instance.drawCrossedSquaresBounded(iicon, x, y, z, 1.0f);
            }
        } else {
            AxisAlignedBB bound = bounds[0];
            for (AxisAlignedBB slice : bounds) {
                if (!(slice.field_72337_e > bound.field_72337_e)) continue;
                bound = slice;
            }
            RenderHelper.instance.setRenderBounds(bound.field_72340_a, 0.0, bound.field_72339_c, bound.field_72336_d, 1.0, bound.field_72334_f);
            RenderHelper.instance.drawCrossedSquaresBounded(iicon, x, y, z, 1.0f);
        }
    }

    public IIcon getIcon(Block block, IBlockAccess blockAccess, int meta) {
        boolean isTopHalf = BlockDoublePlant.func_149887_c((int)meta);
        int baseMeta = BlockDoublePlant.func_149890_d((int)meta);
        return Blocks.field_150398_cm.func_149888_a(isTopHalf, baseMeta);
    }
}

