/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block.tile;

import com.jaquadro.minecraft.gardencore.api.IPlantProxy;
import com.jaquadro.minecraft.gardencore.api.block.garden.ISlotMapping;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityGarden
extends TileEntity
implements IInventory {
    private static final int DEFAULT_BIOME_DATA = 65407;
    public static final int SLOT_INVALID = -1;
    private ItemStack[] containerStacks = new ItemStack[this.containerSlotCount()];
    private PlantItem[] containerPlants;
    private String customName;
    private ItemStack substrate;
    private ItemStack substrateSource;
    private boolean hasBiomeOverride;
    private int biomeData = 65407;

    protected int containerSlotCount() {
        return 0;
    }

    public ItemStack getPlantInSlot(int slot) {
        return this.func_70301_a(slot);
    }

    public void clearPlantedContents() {
        BlockGarden block = this.getGardenBlock();
        if (block != null) {
            this.clearReachableContents(0, this.containerSlotCount());
        }
    }

    public void clearReachableContents() {
        this.clearReachableContents(0, this.containerStacks.length);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.containerStacks.length; ++i) {
            if (this.getPlantInSlot(i) == null) continue;
            return false;
        }
        return true;
    }

    private void clearReachableContents(int start, int length) {
        for (int i = start; i < length; ++i) {
            this.setInventorySlotContents(i, null, false);
        }
        BlockGarden.validateBlockState(this);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public List<ItemStack> getReachableContents() {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        for (int i = 0; i < this.containerStacks.length; ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            contents.add(item);
        }
        return contents;
    }

    public boolean isSharedSlot(int slot) {
        BlockGarden block = this.getGardenBlock();
        if (block == null) {
            return false;
        }
        ISlotMapping[] nmap = block.getSlotShareProfile().getNeighborsForSlot(slot);
        return nmap != null && nmap.length > 0;
    }

    public boolean isSlotValid(int slot) {
        if (!this.isSharedSlot(slot)) {
            return true;
        }
        BlockGarden block = this.getGardenBlock();
        for (ISlotMapping mapping : block.getSlotShareProfile().getNeighborsForSlot(slot)) {
            if (block.getConnectionProfile().isAttachedNeighbor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c + mapping.getMappedX(), this.field_145848_d, this.field_145849_e + mapping.getMappedZ())) continue;
            return false;
        }
        return true;
    }

    public boolean isAttachedNeighbor(int nx, int ny, int nz) {
        BlockGarden garden = this.getGardenBlock();
        if (garden == null) {
            return false;
        }
        return garden.getConnectionProfile().isAttachedNeighbor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, nx, ny, nz);
    }

    public BlockGarden getGardenBlock() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (block instanceof BlockGarden) {
            return (BlockGarden)block;
        }
        return null;
    }

    public ItemStack getSubstrate() {
        return this.substrate;
    }

    public ItemStack getSubstrateSource() {
        return this.substrateSource != null ? this.substrateSource : this.substrate;
    }

    public void setSubstrate(ItemStack substrate) {
        this.substrate = substrate != null ? substrate.func_77946_l() : null;
        this.substrateSource = null;
    }

    public void setSubstrate(ItemStack substrate, ItemStack substrateSource) {
        this.substrate = substrate != null ? substrate.func_77946_l() : null;
        this.substrateSource = this.getSubstrateSource() != null ? substrateSource.func_77946_l() : null;
    }

    public boolean hasBiomeDataOverride() {
        return this.hasBiomeOverride;
    }

    public int getBiomeData() {
        return this.biomeData;
    }

    public float getBiomeTemperature() {
        return (float)(this.biomeData & 0x7F) / 127.0f;
    }

    public float getBiomeHumidity() {
        return (float)(this.biomeData >> 7 & 0x7F) / 127.0f;
    }

    public void setBiomeData(int data) {
        this.biomeData = data;
        this.hasBiomeOverride = true;
    }

    private ItemStack getStackLocal(int slot) {
        if (this.containerPlants == null && this.func_145830_o()) {
            this.initializeContainerPlants();
        }
        if (this.containerPlants != null) {
            return this.containerPlants[slot].getPlantSourceItem();
        }
        return this.containerStacks[slot];
    }

    private void setStackLocal(int slot, ItemStack itemStack) {
        if (this.containerPlants == null && this.func_145830_o()) {
            this.initializeContainerPlants();
        }
        if (this.containerPlants != null && this.func_145830_o()) {
            this.containerPlants[slot] = PlantItem.getForItem((IBlockAccess)this.field_145850_b, itemStack);
        }
        this.containerStacks[slot] = itemStack;
    }

    private void initializeContainerPlants() {
        this.containerPlants = new PlantItem[this.containerStacks.length];
        for (int i = 0; i < this.containerStacks.length; ++i) {
            if (this.containerStacks[i] == null) continue;
            this.containerPlants[i] = PlantItem.getForItem((IBlockAccess)this.field_145850_b, this.containerStacks[i]);
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.containerPlants == null && world != null) {
            this.initializeContainerPlants();
        } else if (world == null) {
            this.containerPlants = null;
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList itemList = tag.func_150295_c("Items", 10);
        this.containerStacks = new ItemStack[this.func_70302_i_()];
        this.containerPlants = null;
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            Item itemObj;
            byte slot;
            NBTTagCompound item = itemList.func_150305_b(i);
            if (!item.func_74764_b("Slot") || !item.func_74764_b("Item") || !item.func_74764_b("Data") || (slot = item.func_74771_c("Slot")) < 0 || slot >= this.containerStacks.length || (itemObj = Item.func_150899_d((int)item.func_74765_d("Item"))) == null) continue;
            short itemData = item.func_74765_d("Data");
            this.setStackLocal(slot, new ItemStack(itemObj, 1, (int)itemData));
        }
        this.customName = null;
        if (tag.func_74764_b("CustomName")) {
            this.customName = tag.func_74779_i("CustomName");
        }
        this.substrate = null;
        this.substrateSource = null;
        if (tag.func_74764_b("SubId")) {
            this.substrate = new ItemStack(Item.func_150899_d((int)tag.func_74765_d("SubId")));
            if (tag.func_74764_b("SubDa")) {
                this.substrate.func_77964_b((int)tag.func_74765_d("SubDa"));
            }
            if (tag.func_74764_b("SubSrcId")) {
                this.substrateSource = new ItemStack(Item.func_150899_d((int)tag.func_74765_d("SubSrcId")));
                if (tag.func_74764_b("SubSrcDa")) {
                    this.substrateSource.func_77964_b((int)tag.func_74765_d("SubSrcDa"));
                }
                if (tag.func_150297_b("SubSrcTag", 10)) {
                    this.substrateSource.field_77990_d = tag.func_74775_l("SubSrcTag");
                }
            }
        }
        this.hasBiomeOverride = tag.func_74764_b("Biom");
        this.biomeData = tag.func_74764_b("Biom") ? tag.func_74762_e("Biom") : 65407;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.containerStacks.length; ++i) {
            if (this.containerStacks[i] == null || this.containerStacks[i].func_77973_b() == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            item.func_74777_a("Item", (short)Item.func_150891_b((Item)this.containerStacks[i].func_77973_b()));
            item.func_74777_a("Data", (short)this.containerStacks[i].func_77960_j());
            itemList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
        if (this.substrate != null) {
            tag.func_74777_a("SubId", (short)Item.func_150891_b((Item)this.substrate.func_77973_b()));
            if (this.substrate.func_77960_j() != 0) {
                tag.func_74777_a("SubDa", (short)this.substrate.func_77960_j());
            }
            if (this.substrateSource != null) {
                tag.func_74777_a("SubSrcId", (short)Item.func_150891_b((Item)this.substrateSource.func_77973_b()));
                if (this.substrateSource.func_77960_j() != 0) {
                    tag.func_74777_a("SubSrcDa", (short)this.substrateSource.func_77960_j());
                }
                if (this.substrateSource.field_77990_d != null) {
                    tag.func_74782_a("SubSrcTag", (NBTBase)this.substrateSource.field_77990_d);
                }
            }
        }
        if (this.hasBiomeOverride || this.biomeData != 65407) {
            tag.func_74768_a("Biom", this.biomeData);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int y = this.field_145848_d;
        while (this.func_145831_w().func_147439_a(this.field_145851_c, ++y, this.field_145849_e) instanceof IPlantProxy) {
            this.func_145831_w().func_147479_m(this.field_145851_c, y, this.field_145849_e);
        }
    }

    public int func_70302_i_() {
        return this.containerStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.isSharedSlot(slot)) {
            return this.getStackInSlotIsolated(slot);
        }
        if (!this.isSlotValid(slot)) {
            return null;
        }
        ItemStack stack = this.getStackInSlotIsolated(slot);
        if (stack != null) {
            return stack;
        }
        BlockGarden block = this.getGardenBlock();
        for (ISlotMapping mapping : block.getSlotShareProfile().getNeighborsForSlot(slot)) {
            TileEntityGarden nGarden;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + mapping.getMappedX(), this.field_145848_d, this.field_145849_e + mapping.getMappedZ());
            if (te == null || !(te instanceof TileEntityGarden) || (stack = (nGarden = (TileEntityGarden)te).getStackInSlotIsolated(mapping.getMappedSlot())) == null) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getStackInSlotIsolated(int slot) {
        return this.containerStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(slot, null);
                return stack;
            }
            ItemStack split = stack.func_77979_a(count);
            if (stack.field_77994_a == 0) {
                this.func_70299_a(slot, null);
            }
            this.func_70296_d();
            return split;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.setInventorySlotContents(slot, itemStack, true);
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack, boolean notify) {
        if (!this.isSharedSlot(slot)) {
            this.setInventorySlotContentsIsolated(slot, itemStack, notify);
            return;
        }
        BlockGarden block = this.getGardenBlock();
        for (ISlotMapping mapping : block.getSlotShareProfile().getNeighborsForSlot(slot)) {
            TileEntity te;
            if (!block.getConnectionProfile().isAttachedNeighbor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c + mapping.getMappedX(), this.field_145848_d, this.field_145849_e + mapping.getMappedZ()) || (te = this.field_145850_b.func_147438_o(this.field_145851_c + mapping.getMappedX(), this.field_145848_d, this.field_145849_e + mapping.getMappedZ())) == null || !(te instanceof TileEntityGarden)) continue;
            TileEntityGarden nGarden = (TileEntityGarden)te;
            nGarden.setInventorySlotContentsIsolated(mapping.getMappedSlot(), null, notify);
        }
        this.setInventorySlotContentsIsolated(slot, itemStack, notify);
    }

    protected void setInventorySlotContentsIsolated(int slot, ItemStack itemStack, boolean notify) {
        this.containerStacks[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        if (notify) {
            BlockGarden.validateBlockState(this);
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.gardencore.garden";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (!this.isSlotValid(slot)) {
            return false;
        }
        PlantItem plant = PlantItem.getForItem((IBlockAccess)this.field_145850_b, itemStack);
        if (plant == null) {
            return false;
        }
        BlockGarden block = this.getGardenBlock();
        if (block == null) {
            return false;
        }
        return block.isPlantValidForSlot(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, slot, plant);
    }
}

