/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block.tile;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.machine.ICompostMaterial;
import com.jaquadro.minecraft.gardencore.block.BlockCompostBin;
import com.jaquadro.minecraft.gardencore.core.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCompostBin
extends TileEntity
implements ISidedInventory {
    private ItemStack[] compostItemStacks = new ItemStack[10];
    public int binDecomposeTime;
    private int currentItemSlot;
    public int currentItemDecomposeTime;
    public int itemDecomposeCount;
    private String customName;
    private int[] accessSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    public int getDecompTime() {
        return this.binDecomposeTime;
    }

    public int getCurrentItemDecompTime() {
        return this.currentItemDecomposeTime;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.compostItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = tagList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.compostItemStacks.length) continue;
            this.compostItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.binDecomposeTime = tag.func_74765_d("DecompTime");
        this.currentItemSlot = tag.func_74771_c("DecompSlot");
        this.itemDecomposeCount = tag.func_74771_c("DecompCount");
        this.currentItemDecomposeTime = this.currentItemSlot >= 0 ? TileEntityCompostBin.getItemDecomposeTime(this.compostItemStacks[this.currentItemSlot]) : 0;
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("DecompTime", (short)this.binDecomposeTime);
        tag.func_74774_a("DecompSlot", (byte)this.currentItemSlot);
        tag.func_74774_a("DecompCount", (byte)this.itemDecomposeCount);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.compostItemStacks.length; ++i) {
            if (this.compostItemStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.compostItemStacks[i].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isDecomposing() {
        return this.binDecomposeTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDecomposeTimeRemainingScaled(int scale) {
        if (this.currentItemDecomposeTime == 0) {
            this.currentItemDecomposeTime = 200;
        }
        return (8 - this.itemDecomposeCount) * scale / 9 + this.binDecomposeTime * scale / (this.currentItemDecomposeTime * 9);
    }

    public void func_145845_h() {
        boolean isDecomposing = this.binDecomposeTime > 0;
        int decompCount = this.itemDecomposeCount;
        boolean shouldUpdate = false;
        if (this.binDecomposeTime > 0) {
            --this.binDecomposeTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            int filledSlotCount = 0;
            for (int i = 0; i < 9; ++i) {
                filledSlotCount += this.compostItemStacks[i] != null ? 1 : 0;
            }
            if ((this.binDecomposeTime != 0 || filledSlotCount > 0) && this.binDecomposeTime == 0) {
                if (this.canCompost()) {
                    this.compostItem();
                    shouldUpdate = true;
                }
                this.currentItemSlot = this.selectRandomFilledSlot();
                this.currentItemDecomposeTime = 0;
                if (this.currentItemSlot >= 0 && (this.compostItemStacks[9] == null || this.compostItemStacks[9].field_77994_a < 64)) {
                    this.binDecomposeTime = this.currentItemDecomposeTime = TileEntityCompostBin.getItemDecomposeTime(this.compostItemStacks[this.currentItemSlot]);
                    if (this.binDecomposeTime > 0) {
                        shouldUpdate = true;
                    }
                }
            }
            if (isDecomposing != this.binDecomposeTime > 0 || decompCount != this.itemDecomposeCount) {
                shouldUpdate = true;
                BlockCompostBin.updateBlockState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (shouldUpdate) {
            this.func_70296_d();
        }
    }

    private boolean canCompost() {
        if (this.currentItemSlot == -1) {
            return false;
        }
        if (this.compostItemStacks[this.currentItemSlot] == null) {
            return false;
        }
        if (this.compostItemStacks[this.currentItemSlot].field_77994_a == 0) {
            return false;
        }
        if (this.compostItemStacks[9] == null) {
            return true;
        }
        int result = this.compostItemStacks[9].field_77994_a + 1;
        return result <= this.func_70297_j_() && result <= this.compostItemStacks[9].func_77976_d();
    }

    public void compostItem() {
        if (this.canCompost()) {
            if (this.itemDecomposeCount < 8) {
                ++this.itemDecomposeCount;
            }
            if (this.itemDecomposeCount == 8) {
                ItemStack resultStack = new ItemStack(ModItems.compostPile);
                if (this.compostItemStacks[9] == null) {
                    this.compostItemStacks[9] = resultStack;
                } else if (this.compostItemStacks[9].func_77973_b() == resultStack.func_77973_b()) {
                    this.compostItemStacks[9].field_77994_a += resultStack.field_77994_a;
                }
                this.itemDecomposeCount = 0;
            }
            --this.compostItemStacks[this.currentItemSlot].field_77994_a;
            if (this.compostItemStacks[this.currentItemSlot].field_77994_a == 0) {
                this.compostItemStacks[this.currentItemSlot] = null;
            }
            this.currentItemSlot = -1;
        }
    }

    public boolean hasInputItems() {
        int filledSlotCount = 0;
        for (int i = 0; i < 9; ++i) {
            filledSlotCount += this.compostItemStacks[i] != null ? 1 : 0;
        }
        return filledSlotCount > 0;
    }

    public boolean hasOutputItems() {
        return this.compostItemStacks[9] != null && this.compostItemStacks[9].field_77994_a > 0;
    }

    private int selectRandomFilledSlot() {
        int filledSlotCount = 0;
        for (int i = 0; i < 9; ++i) {
            filledSlotCount += this.compostItemStacks[i] != null ? 1 : 0;
        }
        if (filledSlotCount == 0) {
            return -1;
        }
        int index = this.field_145850_b.field_73012_v.nextInt(filledSlotCount);
        int c = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.compostItemStacks[i] == null || c++ != index) continue;
            return i;
        }
        return -1;
    }

    public static int getItemDecomposeTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ICompostMaterial material = GardenAPI.instance().registries().compost().getCompostMaterialInfo(itemStack);
        if (material == null) {
            return 0;
        }
        return material.getDecomposeTime();
    }

    public static boolean isItemDecomposable(ItemStack itemStack) {
        return TileEntityCompostBin.getItemDecomposeTime(itemStack) > 0;
    }

    public int func_70302_i_() {
        return this.compostItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.compostItemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack returnStack = null;
        if (this.compostItemStacks[slot] != null) {
            if (this.compostItemStacks[slot].field_77994_a <= count) {
                returnStack = this.compostItemStacks[slot];
                this.compostItemStacks[slot] = null;
            } else {
                returnStack = this.compostItemStacks[slot].func_77979_a(count);
                if (this.compostItemStacks[slot].field_77994_a == 0) {
                    this.compostItemStacks[slot] = null;
                }
            }
        }
        if (slot == 9 && this.compostItemStacks[slot] == null) {
            BlockCompostBin.updateBlockState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return returnStack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.compostItemStacks[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.gardencore.compostBin";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot >= 0 && slot < 9) {
            return TileEntityCompostBin.isItemDecomposable(item);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return this.accessSlots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (slot == 9) {
            return false;
        }
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        if (slot != 9) {
            return false;
        }
        if (item == null) {
            return false;
        }
        return item.func_77973_b() == ModItems.compostPile;
    }
}

