/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block.support;

import com.jaquadro.minecraft.gardencore.api.block.garden.ISlotProfile;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class BasicSlotProfile
implements ISlotProfile {
    private static AxisAlignedBB[] defaultClippingBounds = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    protected Slot[] slots;
    protected int[] slotIndexes;

    protected BasicSlotProfile() {
    }

    public BasicSlotProfile(Slot[] slots) {
        this.slots = slots;
        this.slotIndexes = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            this.slotIndexes[i] = slots[i].slot;
        }
    }

    @Override
    public int[] getPlantSlots() {
        return this.slotIndexes;
    }

    @Override
    public boolean isPlantValidForSlot(IBlockAccess blockAccess, int x, int y, int z, int slot, PlantItem plant) {
        if (this.slots == null || slot < 0 || slot >= this.slots.length) {
            return false;
        }
        if (this.slots[slot] == null) {
            return false;
        }
        if (!this.slots[slot].validTypeClasses.contains((Object)plant.getPlantTypeClass())) {
            return false;
        }
        return this.slots[slot].validSizeClasses.contains((Object)plant.getPlantSizeClass());
    }

    @Override
    public float getPlantOffsetX(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        return 0.0f;
    }

    @Override
    public float getPlantOffsetY(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        return 0.0f;
    }

    @Override
    public float getPlantOffsetZ(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        return 0.0f;
    }

    @Override
    public Object openPlantGUI(InventoryPlayer playerInventory, TileEntity gardenTile, boolean client) {
        return null;
    }

    @Override
    public AxisAlignedBB[] getClippingBounds(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        return defaultClippingBounds;
    }

    public static class Slot {
        public int slot;
        public List<PlantType> validTypeClasses = new ArrayList<PlantType>();
        public List<PlantSize> validSizeClasses = new ArrayList<PlantSize>();

        public Slot(int slot, PlantType[] typeClasses, PlantSize[] sizeClasses) {
            int i;
            this.slot = slot;
            for (i = 0; i < typeClasses.length; ++i) {
                this.validTypeClasses.add(typeClasses[i]);
            }
            for (i = 0; i < sizeClasses.length; ++i) {
                this.validSizeClasses.add(sizeClasses[i]);
            }
        }
    }
}

