/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockGardenContainer
extends BlockGarden {
    protected BlockGardenContainer(String blockName, Material material) {
        super(blockName, material);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileEntityGarden te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            ItemStack substrate = te.getSubstrateSource();
            if (substrate == null) {
                substrate = te.getSubstrate();
            }
            if (substrate != null && Block.func_149634_a((Item)substrate.func_77973_b()) != Blocks.field_150355_j) {
                ItemStack item = substrate.func_77946_l();
                item.field_77994_a = 1;
                this.func_149642_a(world, x, y, z, item);
            }
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    @Override
    public ItemStack getGardenSubstrate(IBlockAccess world, int x, int y, int z, int slot) {
        TileEntityGarden te = this.getTileEntity(world, x, y, z);
        return te != null ? te.getSubstrate() : null;
    }

    @Override
    protected boolean applyItemToGarden(World world, int x, int y, int z, EntityPlayer player, ItemStack itemStack, float hitX, float hitY, float hitZ, boolean hitValid) {
        int slot;
        ItemStack item;
        ItemStack itemStack2 = item = itemStack == null ? player.field_71071_by.func_70448_g() : itemStack;
        if (item == null) {
            return false;
        }
        if (this.applySubstrateToGarden(world, x, y, z, (EntityPlayer)(itemStack == null ? player : null), slot = this.getSlot(world, x, y, z, player, hitX, hitY, hitZ), item)) {
            return true;
        }
        return super.applyItemToGarden(world, x, y, z, player, itemStack, hitX, hitY, hitZ, hitValid);
    }

    protected boolean applySubstrateToGarden(World world, int x, int y, int z, EntityPlayer player, int slot, ItemStack itemStack) {
        if (this.getGardenSubstrate((IBlockAccess)world, x, y, z, slot) != null) {
            return false;
        }
        if (!this.isValidSubstrate(world, x, y, z, slot, itemStack)) {
            return false;
        }
        TileEntityGarden garden = this.getTileEntity((IBlockAccess)world, x, y, z);
        ItemStack translation = this.translateSubstrate(world, x, y, z, slot, itemStack);
        if (translation == null || translation == itemStack) {
            garden.setSubstrate(itemStack);
        } else {
            garden.setSubstrate(itemStack, translation);
        }
        garden.func_70296_d();
        world.func_147471_g(x, y, z);
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (--currentItem.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        return true;
    }

    @Override
    protected boolean isPlantValidForSubstrate(ItemStack substrate, PlantItem plant) {
        if (substrate == null || substrate.func_77973_b() == null) {
            return false;
        }
        switch (plant.getPlantTypeClass()) {
            case AQUATIC: 
            case AQUATIC_COVER: 
            case AQUATIC_EMERGENT: 
            case AQUATIC_SURFACE: {
                if (Block.func_149634_a((Item)substrate.func_77973_b()) == Blocks.field_150355_j) break;
                return false;
            }
            case GROUND: 
            case GROUND_COVER: {
                if (Block.func_149634_a((Item)substrate.func_77973_b()) != Blocks.field_150355_j) break;
                return false;
            }
        }
        return super.isPlantValidForSubstrate(substrate, plant);
    }

    protected boolean isValidSubstrate(World world, int x, int y, int z, int slot, ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block == null) {
            return false;
        }
        return block == Blocks.field_150346_d || block == Blocks.field_150354_m || block == Blocks.field_150351_n || block == Blocks.field_150425_aM || block == Blocks.field_150349_c || block == Blocks.field_150355_j || block == Blocks.field_150458_ak || block == Blocks.field_150391_bh || block == ModBlocks.gardenSoil || block == ModBlocks.gardenFarmland;
    }

    protected ItemStack translateSubstrate(World world, int x, int y, int z, int slot, ItemStack itemStack) {
        if (Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150458_ak) {
            return new ItemStack(Blocks.field_150458_ak, 1, 1);
        }
        return itemStack;
    }
}

