/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.api;

import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModItems;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;

public final class SaplingRegistry {
    private final UniqueMetaRegistry<SaplingRecord> registry = new UniqueMetaRegistry();
    private static final SaplingRegistry instance = new SaplingRegistry();

    public static SaplingRegistry instance() {
        return instance;
    }

    private SaplingRegistry() {
        Item sapling = Item.func_150898_a((Block)Blocks.field_150345_g);
        this.registerSapling(sapling, 0, Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0);
        this.registerSapling(sapling, 1, Blocks.field_150364_r, 1, (Block)Blocks.field_150362_t, 1);
        this.registerSapling(sapling, 2, Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2);
        this.registerSapling(sapling, 3, Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3);
        this.registerSapling(sapling, 4, Blocks.field_150363_s, 0, (Block)Blocks.field_150361_u, 0);
        this.registerSapling(sapling, 5, Blocks.field_150363_s, 1, (Block)Blocks.field_150361_u, 1);
    }

    public void registerSapling(Item sapling, int saplingMeta, Block wood, int woodMeta, Block leaf, int leafMeta) {
        if (sapling == null || wood == null || leaf == null) {
            return;
        }
        this.registerSapling(ModItems.getUniqueMetaID(sapling, saplingMeta), ModBlocks.getUniqueMetaID(wood, woodMeta), ModBlocks.getUniqueMetaID(leaf, leafMeta));
    }

    public void registerSapling(UniqueMetaIdentifier sapling, UniqueMetaIdentifier wood, UniqueMetaIdentifier leaf) {
        SaplingRecord record = new SaplingRecord();
        record.saplingType = sapling;
        record.woodType = wood;
        record.leafType = leaf;
        this.registry.register(sapling, record);
    }

    public UniqueMetaIdentifier getLeavesForSapling(Item sapling) {
        return this.getLeavesForSapling(sapling, Short.MAX_VALUE);
    }

    public UniqueMetaIdentifier getLeavesForSapling(Item sapling, int saplingMeta) {
        return this.getLeavesForSapling(ModItems.getUniqueMetaID(sapling, saplingMeta));
    }

    public UniqueMetaIdentifier getLeavesForSapling(UniqueMetaIdentifier sapling) {
        SaplingRecord record = this.registry.getEntry(sapling);
        if (record == null) {
            return null;
        }
        return record.leafType;
    }

    public UniqueMetaIdentifier getWoodForSapling(Item sapling) {
        return this.getWoodForSapling(sapling, Short.MAX_VALUE);
    }

    public UniqueMetaIdentifier getWoodForSapling(Item sapling, int saplingMeta) {
        return this.getWoodForSapling(ModItems.getUniqueMetaID(sapling, saplingMeta));
    }

    public UniqueMetaIdentifier getWoodForSapling(UniqueMetaIdentifier sapling) {
        SaplingRecord record = this.registry.getEntry(sapling);
        if (record == null) {
            return null;
        }
        return record.woodType;
    }

    public Object getExtendedData(Item sapling, String key) {
        return this.getExtendedData(sapling, Short.MAX_VALUE, key);
    }

    public Object getExtendedData(Item sapling, int saplingMeta, String key) {
        return this.getExtendedData(ModItems.getUniqueMetaID(sapling, saplingMeta), key);
    }

    public Object getExtendedData(UniqueMetaIdentifier sapling, String key) {
        SaplingRecord record = this.registry.getEntry(sapling);
        if (record == null) {
            return null;
        }
        return record.extraData.get(key);
    }

    public void putExtendedData(Item sapling, String key, Object data) {
        this.putExtendedData(sapling, Short.MAX_VALUE, key, data);
    }

    public void putExtendedData(Item sapling, int saplingMeta, String key, Object data) {
        this.putExtendedData(ModItems.getUniqueMetaID(sapling, saplingMeta), key, data);
    }

    public void putExtendedData(UniqueMetaIdentifier sapling, String key, Object data) {
        SaplingRecord record = this.registry.getEntry(sapling);
        if (record == null) {
            this.registerSapling(sapling, null, null);
            record = this.registry.getEntry(sapling);
        }
        record.extraData.put(key, data);
    }

    private static class SaplingRecord {
        public UniqueMetaIdentifier saplingType;
        public UniqueMetaIdentifier woodType;
        public UniqueMetaIdentifier leafType;
        public HashMap<String, Object> extraData = new HashMap();

        private SaplingRecord() {
        }
    }
}

