/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.block;

import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityDecorativePot;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.api.plant.PlantItem;
import com.jaquadro.minecraft.gardencore.api.plant.PlantSize;
import com.jaquadro.minecraft.gardencore.api.plant.PlantType;
import com.jaquadro.minecraft.gardencore.block.BlockGardenContainer;
import com.jaquadro.minecraft.gardencore.block.support.BasicConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.Slot2Profile;
import com.jaquadro.minecraft.gardencore.block.support.SlotShare0Profile;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDecorativePot
extends BlockGardenContainer {
    public BlockDecorativePot(String blockName) {
        super(blockName, Material.field_151576_e);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149769_e);
        this.connectionProfile = new BasicConnectionProfile();
        this.slotShareProfile = new SlotShare0Profile();
        PlantType[] commonType = new PlantType[]{PlantType.GROUND, PlantType.AQUATIC, PlantType.AQUATIC_EMERGENT};
        PlantSize[] allSize = new PlantSize[]{PlantSize.FULL, PlantSize.LARGE, PlantSize.MEDIUM, PlantSize.SMALL};
        this.slotProfile = new LocalSlotProfile(new BasicSlotProfile.Slot[]{new BasicSlotProfile.Slot(0, commonType, allSize), new BasicSlotProfile.Slot(1, new PlantType[]{PlantType.GROUND_COVER}, allSize)});
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    protected boolean isValidSubstrate(World world, int x, int y, int z, int slot, ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        if (Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150424_aL) {
            return true;
        }
        return super.isValidSubstrate(world, x, y, z, slot, itemStack);
    }

    @Override
    public int getDefaultSlot() {
        return 0;
    }

    @Override
    protected int getSlot(World world, int x, int y, int z, EntityPlayer player, float hitX, float hitY, float hitZ) {
        return 0;
    }

    @Override
    protected int getEmptySlotForPlant(World world, int x, int y, int z, EntityPlayer player, PlantItem plant) {
        if (plant.getPlantTypeClass() == PlantType.GROUND_COVER) {
            return 1;
        }
        return 0;
    }

    public int func_149645_b() {
        return ClientProxy.decorativePotRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public TileEntityDecorativePot getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityDecorativePot ? (TileEntityDecorativePot)te : null;
    }

    @Override
    public TileEntityDecorativePot createNewTileEntity(World var1, int var2) {
        return new TileEntityDecorativePot();
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.5f, 0.8125f);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    protected boolean applyItemToGarden(World world, int x, int y, int z, EntityPlayer player, ItemStack itemStack, float hitX, float hitY, float hitZ, boolean hitValid) {
        ItemStack substrate;
        ItemStack item;
        ItemStack itemStack2 = item = itemStack == null ? player.field_71071_by.func_70448_g() : itemStack;
        if (item != null && item.func_77973_b() == Items.field_151033_d && (substrate = this.getGardenSubstrate((IBlockAccess)world, x, y, z, 0)) != null && substrate.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150424_aL)) {
            if (world.func_147437_c(x, y + 1, z)) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                world.func_147449_b(x, y + 1, z, (Block)ModBlocks.smallFire);
                world.func_147459_d(x, y, z, (Block)this);
                world.func_147459_d(x, y - 1, z, (Block)this);
            }
            item.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return super.applyItemToGarden(world, x, y, z, player, itemStack, hitX, hitY, hitZ, hitValid);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        if (this.isSconceLit((IBlockAccess)world, x, y, z)) {
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (block == ModBlocks.smallFire && world.func_147439_a(x, y + 1, z) != ModBlocks.smallFire) {
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return side == 1 && this.isSconceLit(world, x, y, z) ? 15 : 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.isSconceLit(world, x, y, z) ? 15 : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    private boolean isSconceLit(IBlockAccess world, int x, int y, int z) {
        ItemStack substrate = this.getGardenSubstrate(world, x, y, z, 0);
        if (substrate != null && substrate.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150424_aL)) {
            return world.func_147439_a(x, y + 1, z) == ModBlocks.smallFire;
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 3; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 2) {
            side = 1;
        }
        return Blocks.field_150371_ca.func_149691_a(side, meta);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_72805_g(x, y, z) == 2) {
            side = 1;
        }
        return Blocks.field_150371_ca.func_149673_e(world, x, y, z, side);
    }

    public void func_149651_a(IIconRegister register) {
    }

    private class LocalSlotProfile
    extends Slot2Profile {
        public LocalSlotProfile(BasicSlotProfile.Slot[] slots) {
            super(slots);
        }

        @Override
        public float getPlantOffsetY(IBlockAccess blockAccess, int x, int y, int z, int slot) {
            return -0.0625f;
        }
    }
}

