/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.client.gui;

import com.jaquadro.minecraft.gardenstuff.block.tile.TileBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.inventory.ContainerBloomeryFurnace;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBloomeryFurnace
extends GuiContainer {
    private static final ResourceLocation FURNACE_GUI_TEXTURES = new ResourceLocation("gardenstuff", "textures/gui/bloomery_furnace.png");
    private final InventoryPlayer playerInventory;
    private final IInventory containerInventory;

    public GuiBloomeryFurnace(InventoryPlayer playerInventory, IInventory containerInventory) {
        super((Container)new ContainerBloomeryFurnace(playerInventory, containerInventory));
        this.playerInventory = playerInventory;
        this.containerInventory = containerInventory;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = this.containerInventory.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(FURNACE_GUI_TEXTURES);
        int halfW = (this.field_146294_l - this.field_146999_f) / 2;
        int halfH = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(halfW, halfH, 0, 0, this.field_146999_f, this.field_147000_g);
        if (TileBloomeryFurnace.isBurning(this.containerInventory)) {
            int burnLeft = this.getBurnLeftScaled(13);
            this.func_73729_b(halfW + 56, halfH + 36 + 12 - burnLeft, 176, 12 - burnLeft, 14, burnLeft + 1);
        }
        int cookProgress = this.getCookProgressScaled(24);
        this.func_73729_b(halfW + 79, halfH + 34, 176, 14, cookProgress + 1, 16);
    }

    private int getCookProgressScaled(int pixels) {
        int cookTime = this.containerInventory.func_174887_a_(2);
        int totalCookTime = this.containerInventory.func_174887_a_(3);
        if (totalCookTime != 0 && cookTime != 0) {
            return cookTime * pixels / totalCookTime;
        }
        return 0;
    }

    private int getBurnLeftScaled(int pixels) {
        int furnaceBurnTime = this.containerInventory.func_174887_a_(0);
        int currentItemBurnTime = this.containerInventory.func_174887_a_(1);
        if (currentItemBurnTime == 0) {
            currentItemBurnTime = 200;
        }
        return furnaceBurnTime * pixels / currentItemBurnTime;
    }
}

