/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ConfigManagerMars {
    public static boolean loaded;
    public static Configuration config;
    public static List<String> propOrder;
    public static int dimensionIDMars;
    public static int idSchematicRocketT2;
    public static int idSchematicCargoRocket;
    public static boolean launchControllerChunkLoad;
    public static boolean launchControllerAllDims;
    public static boolean disableDeshGen;
    public static boolean disableTinGen;
    public static boolean disableCopperGen;
    public static boolean disableIronGen;

    public ConfigManagerMars(File file, boolean update) {
        if (!loaded) {
            config = new Configuration(file);
            ConfigManagerMars.syncConfig(true, update);
        }
    }

    public static void syncConfig(boolean load, boolean update) {
        try {
            if (!ConfigManagerMars.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDMars", -29);
            prop.comment = "Dimension ID for Mars";
            prop.setLanguageKey("gc.configgui.dimensionIDMars").setRequiresMcRestart(true);
            dimensionIDMars = prop.getInt();
            prop = config.get("schematic", "idSchematicRocketT2", 2);
            prop.comment = "Schematic ID for Tier 2 Rocket, must be unique.";
            prop.setLanguageKey("gc.configgui.idSchematicRocketT2");
            idSchematicRocketT2 = prop.getInt(2);
            prop = config.get("schematic", "idSchematicCargoRocket", 3);
            prop.comment = "Schematic ID for Cargo Rocket, must be unique.";
            prop.setLanguageKey("gc.configgui.idSchematicCargoRocket");
            idSchematicCargoRocket = prop.getInt(3);
            prop = config.get("general", "launchControllerChunkLoad", true);
            prop.comment = "Whether or not the launch controller acts as a chunk loader. Will cause issues if disabled!";
            prop.setLanguageKey("gc.configgui.launchControllerChunkLoad");
            launchControllerChunkLoad = prop.getBoolean(true);
            prop = config.get("general", "launchControllerAllDims", false);
            prop.comment = "May rarely cause issues if enabled, depends on how the other mod's dimensions are.";
            prop.setLanguageKey("gc.configgui.launchControllerAllDims");
            launchControllerAllDims = prop.getBoolean(false);
            prop = config.get(update ? "general" : "worldgen", "Disable Iron Ore Gen on Mars", false);
            prop.comment = "Disable Iron Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableIronGenMars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.comment);
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableIronGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get(update ? "general" : "worldgen", "Disable Copper Ore Gen on Mars", false);
            prop.comment = "Disable Copper Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableCopperGenMars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.comment);
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableCopperGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get(update ? "general" : "worldgen", "Disable Tin Ore Gen on Mars", false);
            prop.comment = "Disable Tin Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableTinGenMars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.comment);
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableTinGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get(update ? "general" : "worldgen", "Disable Desh Ore Gen on Mars", false);
            prop.comment = "Disable Desh Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableDeshGenMars");
            if (update) {
                prop = config.get("worldgen", prop.getName(), prop.getBoolean(), prop.comment);
                prop.setLanguageKey(prop.getLanguageKey());
                config.getCategory("general").remove((Object)prop.getName());
            }
            disableDeshGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            if (!load && config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Mars (Planets) has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    static {
        propOrder = new ArrayList<String>();
    }
}

