/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.math;

import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.math.TeleporterDimPos;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public final class BlockDimPos {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int dim;

    @Nullable
    public static BlockDimPos fromIntArray(@Nullable int[] ai) {
        return ai == null || ai.length < 3 ? null : new BlockDimPos(ai[0], ai[1], ai[2], ai.length > 3 ? ai[3] : 0);
    }

    public BlockDimPos(int x, int y, int z, int d) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dim = d;
    }

    public BlockDimPos(double x, double y, double z, int d) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), d);
    }

    public BlockDimPos(Vec3i p, int d) {
        this(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), d);
    }

    public BlockDimPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u + 0.1, entity.field_70161_v, entity.field_71093_bK);
    }

    public BlockDimPos(ICommandSender sender) {
        this((Vec3i)sender.func_180425_c(), sender.func_130014_f_().field_73011_w.getDimension());
    }

    public int[] toIntArray() {
        return new int[]{this.posX, this.posY, this.posZ, this.dim};
    }

    public String toString() {
        return "[" + this.dim + '@' + this.posX + ',' + this.posY + ',' + this.posZ + ']';
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof BlockDimPos) {
            return this.equalsPos((BlockDimPos)o);
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dim;
    }

    public Vec3d toVec() {
        return new Vec3d((double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5);
    }

    public ChunkDimPos toChunkPos() {
        return new ChunkDimPos(MathUtils.chunk(this.posX), MathUtils.chunk(this.posZ), this.dim);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public BlockDimPos copy() {
        return new BlockDimPos(this.posX, this.posY, this.posZ, this.dim);
    }

    public boolean equalsPos(BlockDimPos p) {
        return p == this || p.dim == this.dim && p.posX == this.posX && p.posY == this.posY && p.posZ == this.posZ;
    }

    public BlockDimPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockDimPos(this.posX + x, this.posY + y, this.posZ + z, this.dim);
    }

    public TeleporterDimPos teleporter() {
        return TeleporterDimPos.of((double)this.posX + 0.5, (double)this.posY + 0.1, (double)this.posZ + 0.5, this.dim);
    }
}

