/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.core.model.ModelPart;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.jozufozu.flywheel.vanilla.RenderStates;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class ShulkerBoxInstance
extends TileEntityInstance<ShulkerBoxTileEntity>
implements IDynamicInstance {
    private final TextureAtlasSprite texture;
    private final ModelData base;
    private final ModelData lid;
    private final MatrixTransformStack stack;
    private float lastProgress = Float.NaN;

    public ShulkerBoxInstance(MaterialManager<?> materialManager, ShulkerBoxTileEntity tile) {
        super(materialManager, tile);
        DyeColor color = tile.func_190592_s();
        this.texture = color == null ? Atlases.field_228748_g_.func_229314_c_() : ((RenderMaterial)Atlases.field_228749_h_.get(color.func_196059_a())).func_229314_c_();
        Quaternion rotation = this.getDirection().func_229384_a_();
        this.stack = new MatrixTransformStack();
        this.stack.translate((Vector3i)this.getInstancePosition()).scale(0.9995f).translateAll(2.5E-4).centre().multiply(rotation).unCentre();
        this.base = this.makeBaseInstance().setTransform(this.stack.unwrap());
        this.stack.translateY(0.25);
        this.lid = this.makeLidInstance().setTransform(this.stack.unwrap());
    }

    @Override
    public void beginFrame() {
        float progress = ((ShulkerBoxTileEntity)this.tile).func_190585_a(AnimationTickHolder.getPartialTicks());
        if (progress == this.lastProgress) {
            return;
        }
        this.lastProgress = progress;
        Quaternion spin = Vector3f.field_229181_d_.func_229187_a_(270.0f * progress);
        this.stack.push().centre().multiply(spin).unCentre().translateY(progress * 0.5f);
        this.lid.setTransform(this.stack.unwrap());
        this.stack.pop();
    }

    @Override
    public void remove() {
        this.base.delete();
        this.lid.delete();
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.base, this.lid);
    }

    private ModelData makeBaseInstance() {
        return this.materialManager.cutout(RenderStates.SHULKER).material(Materials.TRANSFORMED).model("base_" + this.texture.func_195668_m(), this::makeBaseModel).createInstance();
    }

    private ModelData makeLidInstance() {
        return this.materialManager.cutout(RenderStates.SHULKER).material(Materials.TRANSFORMED).model("lid_" + this.texture.func_195668_m(), this::makeLidModel).createInstance();
    }

    private ModelPart makeBaseModel() {
        return ModelPart.builder(64, 64).sprite(this.texture).cuboid().textureOffset(0, 28).size(16.0f, 8.0f, 16.0f).invertYZ().endCuboid().build();
    }

    private ModelPart makeLidModel() {
        return ModelPart.builder(64, 64).sprite(this.texture).cuboid().size(16.0f, 12.0f, 16.0f).invertYZ().endCuboid().build();
    }

    private Direction getDirection() {
        if (this.blockState.func_177230_c() instanceof ShulkerBoxBlock) {
            return (Direction)this.blockState.func_177229_b((Property)ShulkerBoxBlock.field_190957_a);
        }
        return Direction.UP;
    }
}

