/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.core.shader.extension.IExtensionInstance;
import com.jozufozu.flywheel.core.shader.extension.IProgramExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtensibleGlProgram
extends GlProgram {
    protected final List<IExtensionInstance> extensions;

    public ExtensibleGlProgram(Program program, @Nullable List<IProgramExtension> extensions) {
        super(program);
        if (extensions != null) {
            ArrayList<IExtensionInstance> list = new ArrayList<IExtensionInstance>();
            for (IProgramExtension e : extensions) {
                IExtensionInstance extension = e.create(this);
                list.add(extension);
            }
            this.extensions = list;
        } else {
            this.extensions = Collections.emptyList();
        }
    }

    @Override
    public void bind() {
        super.bind();
        this.extensions.forEach(IExtensionInstance::bind);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("program ").append(this.name).append('[');
        for (IExtensionInstance extension : this.extensions) {
            builder.append(extension).append('+');
        }
        builder.append(']');
        return builder.toString();
    }

    public static interface Factory<P extends GlProgram> {
        @Nonnull
        public P create(Program var1, @Nullable List<IProgramExtension> var2);

        default public P create(Program program) {
            return this.create(program, null);
        }
    }
}

