/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.InstanceWorld;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.WorldAttached;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InstancedRenderDispatcher {
    private static final WorldAttached<InstanceWorld> instanceWorlds = new WorldAttached<InstanceWorld>($ -> new InstanceWorld());

    @Nonnull
    public static InstanceManager<TileEntity> getTiles(IWorld world) {
        return instanceWorlds.get(world).getTileEntityInstanceManager();
    }

    @Nonnull
    public static InstanceManager<Entity> getEntities(IWorld world) {
        return instanceWorlds.get(world).getEntityInstanceManager();
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (!Backend.isGameActive() || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        AnimationTickHolder.tick();
        instanceWorlds.get((IWorld)world).tick();
    }

    public static void enqueueUpdate(TileEntity te) {
        InstancedRenderDispatcher.getTiles((IWorld)te.func_145831_w()).queueUpdate(te);
    }

    public static void enqueueUpdate(Entity entity) {
        InstancedRenderDispatcher.getEntities((IWorld)entity.field_70170_p).queueUpdate(entity);
    }

    @SubscribeEvent
    public static void onBeginFrame(BeginFrameEvent event) {
        instanceWorlds.get((IWorld)event.getWorld()).beginFrame(event);
    }

    @SubscribeEvent
    public static void renderLayer(RenderLayerEvent event) {
        if (event.layer == null) {
            return;
        }
        ClientWorld world = event.getWorld();
        if (!Backend.getInstance().canUseInstancing((World)world)) {
            return;
        }
        instanceWorlds.get((IWorld)world).renderLayer(event);
    }

    @SubscribeEvent
    public static void onReloadRenderers(ReloadRenderersEvent event) {
        ClientWorld world = event.getWorld();
        if (Backend.getInstance().canUseInstancing() && world != null) {
            InstancedRenderDispatcher.loadAllInWorld(world);
        }
    }

    public static void loadAllInWorld(ClientWorld world) {
        instanceWorlds.replace((IWorld)world, InstanceWorld::delete).loadAll(world);
    }
}

