/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.util;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.util.BlockPos;
import ic2.api.item.IElectricItem;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GeneralUtil {
    public static Item getMinecraftItem(String name) {
        Item item = (Item)GameData.getItemRegistry().getRaw("minecraft:" + name);
        return item;
    }

    public static String safeLocalize(String text) {
        if (StatCollector.func_74838_a((String)text) != null) {
            return StatCollector.func_74838_a((String)text);
        }
        return StatCollector.func_150826_b((String)text);
    }

    public static int getBurnTime(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 14400;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)itemStack);
    }

    public static boolean isItemStackValidElectrical(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (ModCompatibility.IC2Loaded && item instanceof IElectricItem) {
            return ((IElectricItem)item).canProvideEnergy(itemStack);
        }
        return item instanceof IEnergyContainerItem;
    }

    public static boolean isBlockValidGrowable(Block block, World world, BlockPos blockPos) {
        boolean result = false;
        if (block instanceof IGrowable && ((IGrowable)block).func_149851_a(world, blockPos.posX, blockPos.posY, blockPos.posZ, false) || ModCompatibility.ACLoaded && ModCompatibility.getInstance().isBlockValidAgriCraftSeed(block, world, blockPos)) {
            Logger.getGlobal().info("blockcangrow: " + (block instanceof IGrowable && ((IGrowable)block).func_149851_a(world, blockPos.posX, blockPos.posY, blockPos.posZ, false)));
            result = true;
        }
        return result;
    }

    public static Block getBlockFromDirection(World world, int x, int y, int z, ForgeDirection direction, int distance) {
        return world.func_147439_a(x + direction.offsetX * distance, y + direction.offsetY * distance, z + direction.offsetZ * distance);
    }
}

