/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.client.gui.container;

import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class BaseFloodlightContainer<T extends TileEntityMetaFloodlight>
extends Container {
    protected InventoryPlayer invPlayer;
    protected T entity;

    BaseFloodlightContainer(InventoryPlayer invPlayer, T entity) {
        this.invPlayer = invPlayer;
        this.entity = entity;
    }

    void initialize() {
        Pair<Integer, Integer> hotbarOffset = this.getHotbarOffset();
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)this.invPlayer, x, hotbarOffset.getFirst() + x * 18, hotbarOffset.getSecond().intValue()));
        }
        Pair<Integer, Integer> inventoryOffset = this.getInventoryOffset();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)this.invPlayer, 9 + x + y * 9, inventoryOffset.getFirst() + x * 18, inventoryOffset.getSecond() + y * 18));
            }
        }
        ((TileEntityFL)((Object)this.entity)).onInventoryOpen(this.invPlayer.field_70458_d);
    }

    protected abstract boolean mergeIntoThisContainer(int var1, ItemStack var2);

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        ((TileEntityFL)((Object)this.entity)).onInventoryClose(playerIn);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        ItemStack ret = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(slotId);
        if (slot.func_75216_d()) {
            ItemStack itemstack = slot.func_75211_c();
            ret = itemstack.func_77946_l();
            if (slotId >= 36 ? !this.func_75135_a(itemstack, 0, 36, false) : !this.mergeIntoThisContainer(slotId, itemstack)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(player, itemstack);
        }
        return ret;
    }

    protected abstract Pair<Integer, Integer> getHotbarOffset();

    protected abstract Pair<Integer, Integer> getInventoryOffset();
}

