/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.capability;

import de.keridos.floodlights.handler.ConfigHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage {
    public static final int EU_TO_RF_RATE = 4;
    private ItemStack delegate;
    private int prevStorageRatio;

    public CustomEnergyStorage(ItemStack delegate) {
        this();
        this.delegate = delegate;
        if (delegate.func_77978_p() == null) {
            delegate.func_77982_d(new NBTTagCompound());
        }
        this.readFromNBT(delegate.func_77978_p());
    }

    public CustomEnergyStorage() {
        super(ConfigHandler.energyBufferSize);
    }

    public void setEnergyStored(int energy) {
        this.energy = Math.max(0, Math.min(energy, this.capacity));
    }

    public double receiveEU(double amount) {
        int received = this.receiveEnergy((int)Math.round(amount * 4.0), false);
        return amount - (double)received / 4.0;
    }

    public boolean isFull() {
        return this.getEnergyStored() == this.getMaxEnergyStored();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int prev = this.getEnergyStored();
        int result = super.receiveEnergy(maxReceive, simulate);
        if (this.delegate != null && this.getEnergyStored() != prev) {
            this.writeToNBT(this.delegate.func_77978_p());
        }
        return result;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int prev = this.getEnergyStored();
        int result = super.extractEnergy(maxExtract, simulate);
        if (this.delegate != null && this.getEnergyStored() != prev) {
            this.writeToNBT(this.delegate.func_77978_p());
        }
        return result;
    }

    public boolean storageChanged() {
        int ratio = Math.round((float)this.energy * 1000.0f / (float)this.capacity);
        if (Math.abs(ratio - this.prevStorageRatio) > 10 || ratio != this.prevStorageRatio && (this.energy == 0 || this.energy == this.capacity)) {
            this.prevStorageRatio = ratio;
            return true;
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("storageFE")) {
            this.setEnergyStored(nbtTagCompound.func_74762_e("storageFE"));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("storageFE", this.energy);
    }
}

