/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.core.NetworkDataList;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCarbonFloodlight
extends TileEntityMetaFloodlight {
    public int timeRemaining = 0;

    @Override
    protected int getInventorySize() {
        return 2;
    }

    @Override
    public boolean supportsCloak() {
        return true;
    }

    @Override
    public void readOwnFromNBT(NBTTagCompound nbtTagCompound) {
        super.readOwnFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("timeRemaining")) {
            this.timeRemaining = nbtTagCompound.func_74762_e("timeRemaining");
        }
    }

    @Override
    public NBTTagCompound writeOwnToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.writeOwnToNBT(nbtTagCompound);
        nbtTagCompound.func_74768_a("timeRemaining", this.timeRemaining);
        return nbtTagCompound;
    }

    @Override
    public NetworkDataList getSyncData(@Nonnull NetworkDataList data) {
        super.getSyncData(data);
        data.add(this.timeRemaining);
        return data;
    }

    @Override
    public void applySyncData(ByteBuf buffer) {
        super.applySyncData(buffer);
        this.timeRemaining = buffer.readInt();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.isReady()) {
            return;
        }
        if (this.active && this.timeRemaining > 0) {
            --this.timeRemaining;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timeRemaining == 0 && !this.inventory.getStackInSlot(0).func_190926_b()) {
            int factor = this.mode == 0 ? 20 : 10;
            this.timeRemaining = ConfigHandler.carbonTime * GeneralUtil.getBurnTime(this.inventory.getStackInSlot(0)) / 1600 * factor;
            this.inventory.extractItem(0, 1, false);
            this.syncWithAccessors();
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.timeRemaining > 0;
    }

    @Override
    public void changeMode(EntityPlayer player) {
        int newMode;
        int n = newMode = this.mode == 2 ? 0 : this.mode + 1;
        if (newMode == 1) {
            this.timeRemaining /= 4;
        } else if (newMode == 0) {
            this.timeRemaining *= 4;
        }
        super.changeMode(player);
    }
}

