/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import de.keridos.floodlights.FloodLights;
import de.keridos.floodlights.block.BlockFL;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockFLColorableMachine
extends BlockFL {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyInteger COLOR = PropertyInteger.func_177719_a((String)"color", (int)0, (int)15);
    protected int guiId = -1;

    public BlockFLColorableMachine(String unlocName, Material material, SoundType type, float hardness) {
        super(unlocName, material, type, hardness);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile;
        TileEntity tileEntity = tile = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityMetaFloodlight) {
            TileEntityMetaFloodlight metaFloodlight = (TileEntityMetaFloodlight)tile;
            if (metaFloodlight.supportsCloak() && metaFloodlight.getCloak() != null) {
                return metaFloodlight.getCloak();
            }
            return state.func_177226_a((IProperty)FACING, (Comparable)metaFloodlight.getOrientation()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(metaFloodlight.hasLight())).func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(metaFloodlight.getColor()));
        }
        return state;
    }

    protected final BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        this.buildBlockState(builder);
        return builder.build();
    }

    protected void buildBlockState(BlockStateContainer.Builder builder) {
        builder.add(new IProperty[]{COLOR}).add(new IProperty[]{FACING}).add(new IProperty[]{ACTIVE});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityMetaFloodlight tileEntity = (TileEntityMetaFloodlight)world.func_175625_s(pos);
        if (tileEntity == null) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem == ItemStack.field_190927_a && player.func_70093_af()) {
            tileEntity.toggleInverted();
            String invert = GeneralUtil.safeLocalize(tileEntity.getInverted() ? "gui.floodlights:true" : "gui.floodlights:false");
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.floodlights:invert", new Object[]{invert}));
            return true;
        }
        if (heldItem != ItemStack.field_190927_a) {
            if (!ModCompatibility.WrenchAvailable && heldItem.func_77973_b() == GeneralUtil.getMinecraftItem("stick")) {
                tileEntity.changeMode(player);
                return true;
            }
            if (player.func_70093_af() && ModCompatibility.getInstance().isItemValidWrench(heldItem)) {
                world.func_175655_b(pos, true);
                return true;
            }
            if (ModCompatibility.getInstance().isItemValidWrench(heldItem)) {
                tileEntity.changeMode(player);
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151100_aR) {
                tileEntity.setColor(15 - heldItem.func_77952_i());
                return true;
            }
        }
        player.openGui((Object)FloodLights.instance, this.guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityMetaFloodlight) {
            ((TileEntityMetaFloodlight)world.func_175625_s(pos)).setHasRedstoneSignal(world.func_175687_A(pos) > 0);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState block) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityMetaFloodlight) {
            ((TileEntityMetaFloodlight)world.func_175625_s(pos)).setHasRedstoneSignal(world.func_175687_A(pos) > 0);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMetaFloodlight) {
            ((TileEntityMetaFloodlight)tileEntity).setHasRedstoneSignal(false);
            ((TileEntityMetaFloodlight)tileEntity).notifyBlockRemoved();
        }
        super.func_180663_b(world, pos, blockState);
    }
}

