/*
 * Decompiled with CFR 0.152.
 */
package farseek.tfc;

import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenAcaciaKoaTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenCustomShortTrees;
import com.bioxx.tfc.WorldGen.Generators.Trees.WorldGenKapokTrees;
import com.bioxx.tfc.WorldGen.Generators.WorldGenCustomVines;
import com.bioxx.tfc.WorldGen.Generators.WorldGenJungleShrub;
import com.bioxx.tfc.WorldGen.TFCBiome;
import com.bioxx.tfc.api.Enums.EnumTree;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenForests
implements IWorldGenerator {
    private WorldGenerator gen0;
    private WorldGenerator gen1;
    private WorldGenerator gen2;
    private int treeType0;
    private int treeType1;
    private int treeType2;
    private float evt;
    private float rainfall;
    private float temperature = 20.0f;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72807_a(chunkX *= 16, chunkZ *= 16) instanceof TFCBiome) {
            TFCBiome biome = (TFCBiome)world.func_72807_a(chunkX, chunkZ);
            if (biome == TFCBiome.OCEAN || biome == TFCBiome.DEEP_OCEAN) {
                return;
            }
            this.rainfall = TFC_Climate.getRainfall((World)world, (int)chunkX, (int)0, (int)chunkZ);
            this.evt = TFC_Climate.getCacheManager((World)world).getEVTLayerAt((int)(chunkX + 8), (int)(chunkZ + 8)).floatdata1;
            this.treeType0 = TFC_Climate.getTreeLayer((World)world, (int)chunkX, (int)144, (int)chunkZ, (int)0);
            this.treeType1 = TFC_Climate.getTreeLayer((World)world, (int)chunkX, (int)144, (int)chunkZ, (int)1);
            this.treeType2 = TFC_Climate.getTreeLayer((World)world, (int)chunkX, (int)144, (int)chunkZ, (int)2);
            this.gen0 = TFCBiome.getTreeGen((int)this.treeType0, (Boolean)random.nextBoolean());
            this.gen1 = TFCBiome.getTreeGen((int)this.treeType1, (Boolean)random.nextBoolean());
            this.gen2 = TFCBiome.getTreeGen((int)this.treeType2, (Boolean)random.nextBoolean());
            if (!this.generateJungle(random, chunkX, chunkZ, world)) {
                this.generateForest(random, chunkX, chunkZ, world);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateForest(Random random, int chunkX, int chunkZ, World world) {
        int xCoord = chunkX;
        int yCoord = 145;
        int zCoord = chunkZ;
        int numTreesBase = 8;
        if (random.nextInt(10) == 0) {
            numTreesBase -= 6;
        }
        int numTrees = 1;
        for (int var2 = 0; var2 < numTrees; ++var2) {
            xCoord = chunkX + 8 + random.nextInt(16);
            zCoord = chunkZ + 8 + random.nextInt(16);
            yCoord = world.func_72976_f(xCoord, zCoord);
            numTrees = (int)((float)numTreesBase + this.rainfall / 1000.0f * 2.0f);
            if (numTrees > 30) {
                numTrees = 30;
            }
            this.temperature = TFC_Climate.getBioTemperatureHeight((World)world, (int)xCoord, (int)world.func_72976_f(xCoord, zCoord), (int)zCoord);
            int spawnParam0 = this.canTreeSpawn(this.treeType0);
            int spawnParam1 = this.canTreeSpawn(this.treeType1);
            int spawnParam2 = this.canTreeSpawn(this.treeType2);
            if (this.getNearWater(world, xCoord, yCoord, zCoord)) {
                this.rainfall *= 2.0f;
                this.evt /= 2.0f;
            }
            try {
                int randomNumber;
                if (zCoord > 14500 || zCoord < -14500) {
                    this.gen2 = TFCBiome.getTreeGen((int)8, (Boolean)random.nextBoolean());
                }
                if ((spawnParam0 & 1) <= 0 && (spawnParam1 & 1) <= 0 && (spawnParam2 & 1) <= 0) return;
                if (spawnParam0 > 0 && (spawnParam0 & 2) == 0 && spawnParam1 > 0 && (spawnParam1 & 2) == 0 && spawnParam2 > 0 && (spawnParam2 & 2) == 0) {
                    if (random.nextInt(8) != 0) return;
                    numTrees = 1;
                }
                if ((randomNumber = random.nextInt(100)) < 50 && this.gen0 != null && (spawnParam0 == 5 || spawnParam0 == 7)) {
                    this.gen0.func_76484_a(world, random, xCoord, yCoord, zCoord);
                    continue;
                }
                if (randomNumber < 80 && this.gen1 != null && (spawnParam1 == 5 || spawnParam1 == 7)) {
                    this.gen1.func_76484_a(world, random, xCoord, yCoord, zCoord);
                    continue;
                }
                if (randomNumber >= 100 || this.gen2 == null || spawnParam2 != 5 && spawnParam2 != 7) continue;
                this.gen2.func_76484_a(world, random, xCoord, yCoord, zCoord);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private int canTreeSpawn(int tree) {
        float treeEVTMin = tree != -1 ? EnumTree.values()[tree].minEVT : 0.0f;
        float treeEVTMax = tree != -1 ? EnumTree.values()[tree].maxEVT : 0.0f;
        float treeRainMin = tree != -1 ? EnumTree.values()[tree].minRain : 0.0f;
        float treeRainMax = tree != -1 ? EnumTree.values()[tree].maxRain : 0.0f;
        float treeTempMin = tree != -1 ? EnumTree.values()[tree].minTemp : 0.0f;
        float treeTempMax = tree != -1 ? EnumTree.values()[tree].maxTemp : 0.0f;
        int out = 0;
        if (this.temperature >= treeTempMin && this.temperature <= treeTempMax) {
            ++out;
        }
        if (this.evt >= treeEVTMin && this.evt <= treeEVTMax) {
            out += 2;
        }
        if (this.rainfall >= treeRainMin && this.rainfall <= treeRainMax) {
            out += 4;
        }
        return out;
    }

    public boolean generateJungle(Random random, int chunkX, int chunkZ, World world) {
        boolean completed = false;
        int xCoord = chunkX;
        int yCoord = 145;
        int zCoord = chunkZ;
        int numTrees = 50;
        for (int var2 = 0; var2 < numTrees; ++var2) {
            xCoord = chunkX + 8 + random.nextInt(16);
            zCoord = chunkZ + 8 + random.nextInt(16);
            yCoord = world.func_72976_f(xCoord, zCoord);
            float temperatureAvg = TFC_Climate.getBioTemperature((World)world, (int)xCoord, (int)zCoord);
            try {
                Object gen0;
                if (this.evt <= EnumTree.KAPOK.maxEVT && this.rainfall >= EnumTree.KAPOK.minRain && this.rainfall <= EnumTree.KAPOK.maxRain && temperatureAvg >= EnumTree.KAPOK.minTemp && temperatureAvg <= EnumTree.KAPOK.maxTemp) {
                    gen0 = random.nextInt(5) == 0 ? new WorldGenKapokTrees(false, 15) : (random.nextInt(2) == 0 ? new WorldGenCustomShortTrees(false, 15) : new WorldGenJungleShrub(15));
                    gen0.func_76487_a(1.0, 1.0, 1.0);
                    gen0.func_76484_a(world, random, xCoord, yCoord, zCoord);
                    completed = true;
                }
                if (!(this.evt <= EnumTree.KOA.maxEVT) || !(this.rainfall >= EnumTree.KOA.minRain) || !(this.rainfall <= EnumTree.KOA.maxRain) || !(temperatureAvg >= EnumTree.KOA.minTemp) || !(temperatureAvg <= EnumTree.KOA.maxTemp)) continue;
                gen0 = new WorldGenAcaciaKoaTrees(false, 0);
                gen0.func_76487_a(1.0, 1.0, 1.0);
                gen0.func_76484_a(world, random, xCoord, yCoord, zCoord);
                continue;
            }
            catch (IndexOutOfBoundsException gen0) {
                // empty catch block
            }
        }
        if (completed) {
            WorldGenCustomVines vineGen = new WorldGenCustomVines();
            for (int l = 0; l < 50; ++l) {
                int i1 = chunkX + random.nextInt(16) + 8;
                int short1 = 256;
                int j1 = chunkZ + random.nextInt(16) + 8;
                vineGen.generate2(world, random, i1, short1, j1);
            }
        }
        return completed;
    }

    public boolean getNearWater(World world, int x, int y, int z) {
        for (int x1 = -4; x1 < 5; ++x1) {
            for (int z1 = -4; z1 < 5; ++z1) {
                for (int y1 = -2; y1 < 1; ++y1) {
                    if (!world.func_72899_e(x + x1, y + y1, z + z1) || !TFC_Core.isWater((Block)world.func_147439_a(x + x1, y + y1, z + z1))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

