/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Venus.worldgen.dungeon;

import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.Venus.worldgen.dungeon.DungeonBoundingBox;
import com.mjr.extraplanets.planets.Venus.worldgen.dungeon.DungeonRoom;
import com.mjr.extraplanets.planets.Venus.worldgen.dungeon.MapGenDungeon;
import com.mjr.extraplanets.tileEntities.treasureChest.TileEntityT4TreasureChest;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomTreasureVenus
extends DungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final HashSet<ChunkCoordinates> chests = new HashSet();

    public RoomTreasureVenus(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(6) + 7;
            this.sizeY = rand.nextInt(2) + 5;
            this.sizeZ = rand.nextInt(6) + 7;
        }
    }

    @Override
    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (!(i != this.posX && i != this.posX + this.sizeX - 1 || k != this.posZ && k != this.posZ + this.sizeZ - 1)) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150426_aN, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, ExtraPlanets_Blocks.treasureChestTier4, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    @Override
    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomTreasureVenus(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        if (!this.chests.isEmpty()) {
            HashSet<ChunkCoordinates> removeList = new HashSet<ChunkCoordinates>();
            for (ChunkCoordinates coords : this.chests) {
                this.worldObj.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, ExtraPlanets_Blocks.treasureChestTier4, 0, 3);
                this.worldObj.func_147455_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, (TileEntity)new TileEntityT4TreasureChest(4));
                removeList.add(coords);
            }
            this.chests.removeAll(removeList);
        }
    }
}

