/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Venus.worldgen.dungeon;

import com.mjr.extraplanets.planets.Venus.worldgen.dungeon.DungeonBoundingBox;
import com.mjr.extraplanets.planets.Venus.worldgen.dungeon.DungeonRoom;
import com.mjr.extraplanets.planets.Venus.worldgen.dungeon.MapGenDungeon;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomEmptyVenus
extends DungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;

    public RoomEmptyVenus(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(4) + 5;
            this.sizeY = rand.nextInt(2) + 4;
            this.sizeZ = rand.nextInt(4) + 5;
        }
    }

    @Override
    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
    }

    @Override
    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomEmptyVenus(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
    }
}

