/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Saturn.worldgen;

import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.planets.Saturn.worldgen.biomes.BiomeGenSaturn;
import com.mjr.extraplanets.planets.Saturn.worldgen.biomes.BiomeGenSaturnNuclearLand;
import com.mjr.extraplanets.util.WorldGenHelper;
import com.mjr.extraplanets.world.features.WorldGenNuclearPile;
import com.mjr.extraplanets.world.features.WorldGenSlimeTree;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeDecoratorSaturn
extends BiomeDecorator {
    private WorldGenerator tinGen;
    private WorldGenerator copperGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.saturnBlocks, 4, 5, true, ExtraPlanets_Blocks.saturnBlocks, 2);
    private WorldGenerator ironGen;
    private WorldGenerator iceGen;
    private WorldGenerator magnesiumGen;
    private WorldGenerator gravelGen;
    private WorldGenerator slimeGen;
    private int LakesPerChunk = 5;
    private World currentWorld;
    protected Random rand;
    protected int chunkX;
    protected int chunkZ;
    private boolean isDecorating = false;

    public BiomeDecoratorSaturn() {
        this.tinGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.saturnBlocks, 4, 4, true, ExtraPlanets_Blocks.saturnBlocks, 2);
        this.ironGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.saturnBlocks, 8, 3, true, ExtraPlanets_Blocks.saturnBlocks, 2);
        this.iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 18, 0, true, ExtraPlanets_Blocks.saturnBlocks, 2);
        this.magnesiumGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.saturnBlocks, 4, 6, true, ExtraPlanets_Blocks.saturnBlocks, 2);
        this.gravelGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.saturnGravel, 12, 0, true, ExtraPlanets_Blocks.saturnBlocks, 2);
        this.slimeGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.saturnBlocks, 12, 11, true, ExtraPlanets_Blocks.saturnBlocks, 9);
    }

    protected void generateOre(int amountPerChunk, WorldGenerator worldGenerator, int minY, int maxY) {
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            int var6 = this.chunkX + this.rand.nextInt(16);
            int var7 = this.rand.nextInt(maxY - minY) + minY;
            int var8 = this.chunkZ + this.rand.nextInt(16);
            worldGenerator.func_76484_a(this.currentWorld, this.rand, var6, var7, var8);
        }
    }

    public void func_150512_a(World world, Random rand, BiomeGenBase biome, int xChunk, int zChunk) {
        int i;
        this.currentWorld = world;
        this.rand = rand;
        this.chunkX = xChunk;
        this.chunkZ = zChunk;
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        this.generateOre(26, this.copperGen, 0, 60);
        this.generateOre(23, this.tinGen, 0, 60);
        this.generateOre(20, this.ironGen, 0, 64);
        this.generateOre(4, this.iceGen, 50, 120);
        this.generateOre(20, this.magnesiumGen, 0, 32);
        this.generateOre(15, this.gravelGen, 0, 80);
        this.generateOre(10, this.slimeGen, 60, 256);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        if (this.currentWorld.func_72807_a(this.chunkX, this.chunkZ) instanceof BiomeGenSaturn) {
            for (i = 0; i < this.LakesPerChunk; ++i) {
                if (this.rand.nextInt(10) != 0) continue;
                WorldGenHelper.generateLake(this.currentWorld, this.rand, this.chunkX, 0, this.chunkZ, ExtraPlanets_Fluids.glowstone, ExtraPlanets_Blocks.saturnBlocks);
            }
        }
        if (this.currentWorld.func_72807_a(this.chunkX, this.chunkZ) instanceof BiomeGenSaturnNuclearLand) {
            for (i = 0; i < this.LakesPerChunk * 2; ++i) {
                if (this.rand.nextInt(10) != 0) continue;
                WorldGenHelper.generateLake(this.currentWorld, this.rand, this.chunkX, 0, this.chunkZ, ExtraPlanets_Fluids.methane, ExtraPlanets_Blocks.saturnBlocks);
            }
            if (this.rand.nextInt(5) == 1) {
                WorldGenHelper.generateStructure(new WorldGenNuclearPile(), this.currentWorld, this.rand, this.chunkX + this.rand.nextInt(16), 0, this.chunkZ + this.rand.nextInt(16));
            }
            if (this.rand.nextInt(5) == 1) {
                WorldGenHelper.generateStructure(new WorldGenSlimeTree(), this.currentWorld, this.rand, this.chunkX + this.rand.nextInt(16), 0, this.chunkZ + this.rand.nextInt(16));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        this.isDecorating = false;
    }
}

