/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Saturn;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Saturn.worldgen.ChunkProviderSaturn;
import com.mjr.extraplanets.planets.Saturn.worldgen.WorldChunkManagerSaturn;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldProviderSaturn
extends WorldProviderSpace
implements IGalacticraftWorldProvider,
ISolarLevel {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.98039216f * f), (double)(0.7529412f * f), (double)(0.4509804f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.9411765f * f), (double)(0.627451f * f), (double)(0.21568628f * f));
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 10320L;
    }

    public boolean shouldForceRespawn() {
        return true;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderSaturn.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerSaturn.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.7f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        if (Config.oldStyleGravity) {
            return 0.058f;
        }
        return 0.015f;
    }

    public int getHeight() {
        return 800;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.2;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ExtraPlanets_Planets.saturn.getTierRequirement();
    }

    public float getFallDamageModifier() {
        if (Config.oldStyleGravity) {
            return 0.38f;
        }
        return 2.1f;
    }

    public float getSoundVolReductionAmount() {
        return 10.0f;
    }

    public CelestialBody getCelestialBody() {
        return ExtraPlanets_Planets.saturn;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getThermalLevelModifier() {
        if (Config.thermalPaddings) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && this.isDaytime()) {
                return 80.0f;
            }
            return 70.0f;
        }
        return -1.5f;
    }

    public float getWindLevel() {
        return 0.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 6.0;
    }
}

