/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Neptune.worldgen.dungeon;

import com.mjr.extraplanets.planets.Neptune.worldgen.dungeon.DungeonBoundingBox;
import com.mjr.extraplanets.planets.Neptune.worldgen.dungeon.MapGenDungeon;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class DungeonRoom {
    public final MapGenDungeon dungeonInstance;
    public World worldObj;
    public int posX;
    public int posY;
    public int posZ;
    public ForgeDirection entranceDir;

    public DungeonRoom(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        this.dungeonInstance = dungeon;
        this.worldObj = dungeon != null ? dungeon.worldObj : null;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.entranceDir = entranceDir;
    }

    public abstract void generate(Block[] var1, byte[] var2, int var3, int var4);

    public abstract DungeonBoundingBox getBoundingBox();

    protected abstract DungeonRoom makeRoom(MapGenDungeon var1, int var2, int var3, int var4, ForgeDirection var5);

    protected abstract void handleTileEntities(Random var1);

    public static DungeonRoom makeRoom(MapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.otherRooms.get(rand.nextInt(dungeon.otherRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    public static DungeonRoom makeBossRoom(MapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.bossRooms.get(rand.nextInt(dungeon.bossRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    public static DungeonRoom makeTreasureRoom(MapGenDungeon dungeon, Random rand, int x, int y, int z, ForgeDirection dir) {
        return dungeon.treasureRooms.get(rand.nextInt(dungeon.treasureRooms.size())).makeRoom(dungeon, x, y, z, dir);
    }

    protected boolean placeBlock(Block[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, Block id, int meta) {
        if (MapGenDungeon.useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return false;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.func_147465_d(x, y, z, id, meta, 0);
        }
        return true;
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }
}

